/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model.decorator;

import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class CombinedModelDecorator<C extends ModelContext>
extends ModelDecorator<C> {
    private final List<ModelDecorator<C>> decorators = new ArrayList<ModelDecorator<C>>();

    public void add(ModelDecorator<C> decorator) {
        this.decorators.add(decorator);
    }

    @Override
    public boolean shouldRenderItem() {
        for (ModelDecorator<C> decorator : this.decorators) {
            if (!decorator.shouldRenderItem()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier) {
        for (ModelDecorator<C> decorator : this.decorators) {
            if (decorator.shouldRenderBase(contextSupplier)) continue;
            return false;
        }
        return super.shouldRenderBase(contextSupplier);
    }

    @Override
    public boolean shouldRenderBase(Supplier<C> contextSupplier, ItemStack stack) {
        for (ModelDecorator<C> decorator : this.decorators) {
            if (decorator.shouldRenderBase(contextSupplier, stack)) continue;
            return false;
        }
        return super.shouldRenderBase(contextSupplier, stack);
    }

    @Override
    public List<RenderType> getRenderTypes(BlockState state) {
        if (this.decorators.isEmpty()) {
            return super.getRenderTypes(state);
        }
        if (this.decorators.size() == 1) {
            return this.decorators.get(0).getRenderTypes(state);
        }
        ArrayList<RenderType> types = new ArrayList<RenderType>(this.decorators.get(0).getRenderTypes(state));
        for (int i = 1; i < this.decorators.size(); ++i) {
            for (RenderType type : this.decorators.get(i).getRenderTypes(state)) {
                if (types.contains(type)) continue;
                types.add(type);
            }
        }
        return types;
    }

    @Override
    public List<RenderType> getRenderTypes(ItemStack stack) {
        if (this.decorators.isEmpty()) {
            return super.getRenderTypes(stack);
        }
        if (this.decorators.size() == 1) {
            return this.decorators.get(0).getRenderTypes(stack);
        }
        ArrayList<RenderType> types = new ArrayList<RenderType>(this.decorators.get(0).getRenderTypes(stack));
        for (int i = 1; i < this.decorators.size(); ++i) {
            for (RenderType type : this.decorators.get(i).getRenderTypes(stack)) {
                if (types.contains(type)) continue;
                types.add(type);
            }
        }
        return types;
    }

    @Override
    public void emitQuads(Supplier<C> contextSupplier, Consumer<BakedModel> emitModel) {
        for (ModelDecorator<C> decorator : this.decorators) {
            decorator.emitQuads(contextSupplier, emitModel);
        }
    }

    @Override
    public void emitItemQuads(Supplier<C> contextSupplier, Consumer<BakedModel> emitModel, ItemStack stack) {
        for (ModelDecorator<C> decorator : this.decorators) {
            decorator.emitItemQuads(contextSupplier, emitModel, stack);
        }
    }
}

