/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import com.mojang.blaze3d.platform.NativeImage;
import immersive_paintings.client.ClientUtils;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.network.c2s.ImageRequest;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.Painting;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ClientPaintingManager {
    static final Map<ResourceLocation, Painting> paintings = new HashMap<ResourceLocation, Painting>();

    public static Map<ResourceLocation, Painting> getPaintings() {
        return paintings;
    }

    public static Painting getPainting(ResourceLocation identifier) {
        return paintings.getOrDefault(identifier, Painting.DEFAULT);
    }

    public static Painting.Texture getPaintingTexture(ResourceLocation identifier, Painting.Type type) {
        if (paintings.containsKey(identifier)) {
            Painting painting = paintings.get(identifier);
            Painting.Texture textureOriginal = painting.getTexture(type);
            Painting.Texture texture = painting.getTexture(textureOriginal.link);
            if (texture.image == null && !texture.requested) {
                texture.requested = true;
                Cache.get(texture).ifPresentOrElse(image -> {
                    texture.image = image;
                    ClientPaintingManager.registerImage(texture);
                }, () -> NetworkHandler.sendToServer(new ImageRequest(identifier, textureOriginal.link)));
            }
            if (texture.image == null) {
                for (Painting.Type t : Painting.Type.values()) {
                    Painting.Texture temporaryTexture = painting.getTexture(t);
                    if (temporaryTexture.image == null) continue;
                    return temporaryTexture;
                }
            }
            return texture;
        }
        return Painting.DEFAULT.texture;
    }

    public static void registerImage(Painting.Texture texture) {
        NativeImage nativeImage = ClientUtils.byteImageToNativeImage(texture.image);
        texture.textureIdentifier = Minecraft.m_91087_().m_91097_().m_118490_("immersive_painting/" + texture.hash, new DynamicTexture(nativeImage));
    }
}

