/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.mixin.client;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
public class ModelBakeryMixin {
    @Unique
    private static final Predicate<ResourceLocation> BACKPACKED_MODEL_TEST = location -> location.m_135815_().startsWith("models/backpacked");
    @Shadow
    @Final
    private Map<ResourceLocation, UnbakedModel> f_119212_;
    @Shadow
    @Final
    private Map<ResourceLocation, UnbakedModel> f_119214_;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void backpacked$OnLoadModels(BlockColors colors, ProfilerFiller filler, Map<ResourceLocation, BlockModel> models, Map<ResourceLocation, List<ModelBakery.LoadedJson>> data, CallbackInfo ci) {
        ModelBakery bakery = (ModelBakery)this;
        models.forEach((key, value) -> {
            if (BACKPACKED_MODEL_TEST.test((ResourceLocation)key)) {
                String path = key.m_135815_().substring("models/".length(), key.m_135815_().length() - ".json".length());
                ResourceLocation location = new ResourceLocation(key.m_135827_(), path);
                UnbakedModel model = bakery.m_119341_(location);
                this.f_119212_.put(location, model);
                this.f_119214_.put(location, model);
            }
        });
    }
}

