/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncBackpacks;
import com.mrcrayfish.backpacked.network.message.MessageUnlockBackpack;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class BackpackManager {
    private static final ResourceLocation FALLBACK_BACKPACK = new ResourceLocation("backpacked", "standard");
    private static BackpackManager instance;
    private Map<ResourceLocation, Backpack> loadedBackpacks = new HashMap<ResourceLocation, Backpack>();
    private Map<ResourceLocation, Backpack> clientBackpacks = new HashMap<ResourceLocation, Backpack>();
    private Map<ResourceLocation, ModelMeta> clientModelMeta = new HashMap<ResourceLocation, ModelMeta>();

    public static BackpackManager instance() {
        if (instance == null) {
            instance = new BackpackManager();
        }
        return instance;
    }

    private BackpackManager() {
    }

    public void updateBackpacks(Map<ResourceLocation, Backpack> map) {
        this.loadedBackpacks = map;
    }

    public void updateModelMeta(Map<ResourceLocation, ModelMeta> map) {
        this.clientModelMeta = map;
    }

    public void updateClientBackpacks(List<Backpack> backpacks) {
        this.clientBackpacks.clear();
        backpacks.forEach(backpack -> this.clientBackpacks.put(backpack.getId(), (Backpack)backpack));
    }

    @Nullable
    public Backpack getBackpack(ResourceLocation id) {
        return this.loadedBackpacks.get(id);
    }

    public List<Backpack> getBackpacks() {
        return ImmutableList.copyOf(this.loadedBackpacks.values());
    }

    @Nullable
    public Backpack getClientBackpack(ResourceLocation id) {
        return this.clientBackpacks.get(id);
    }

    @Nullable
    public Backpack getClientBackpackOrDefault(String id) {
        Backpack backpack = this.clientBackpacks.get(ResourceLocation.m_135820_((String)id));
        if (backpack != null) {
            return backpack;
        }
        ResourceLocation defaultId = ResourceLocation.m_135820_((String)((String)Config.SERVER.backpack.defaultCosmetic.get()));
        backpack = this.clientBackpacks.get(defaultId);
        if (backpack != null) {
            return backpack;
        }
        return this.clientBackpacks.get(FALLBACK_BACKPACK);
    }

    public List<Backpack> getClientBackpacks() {
        return ImmutableList.copyOf(this.clientBackpacks.values());
    }

    public ModelMeta getModelMeta(Backpack backpack) {
        return this.clientModelMeta.getOrDefault(backpack.getId(), ModelMeta.DEFAULT);
    }

    public void unlockBackpack(ServerPlayer player, ResourceLocation id) {
        if (((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue()) {
            return;
        }
        if (!this.loadedBackpacks.containsKey(id)) {
            return;
        }
        UnlockManager.getTracker((Player)player).ifPresent(impl -> {
            if (impl.unlockBackpack(id)) {
                Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageUnlockBackpack(id));
            }
        });
    }

    public MessageSyncBackpacks getSyncMessage() {
        return new MessageSyncBackpacks(this.getBackpacks());
    }
}

