/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.backpack.value.source;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.value.source.SourceTypes;
import net.minecraft.resources.ResourceLocation;

public interface BaseSource {
    public static final Codec<BaseSource> CODEC = Type.CODEC.dispatch(Type::get, Type::codec);

    public Type type();

    public double apply(BackpackRenderContext var1);

    public record Type(ResourceLocation id, Codec<? extends BaseSource> codec) {
        private static final Codec<Type> CODEC = ResourceLocation.f_135803_.flatXmap(id -> {
            Type codec = SourceTypes.getAll().get(id);
            if (codec != null) {
                return DataResult.success((Object)codec);
            }
            return DataResult.error(() -> "Unregistered dynamic value source: " + id);
        }, codec -> {
            if (SourceTypes.getAll().containsKey(codec.id)) {
                return DataResult.success((Object)codec.id);
            }
            return DataResult.error(() -> "Unregistered dynamic value source: " + codec.id);
        });

        private static Type get(BaseSource source) {
            ResourceLocation id = source.type().id();
            if (!SourceTypes.getAll().containsKey(id)) {
                throw new IllegalArgumentException("Unregistered dynamic value source: " + id);
            }
            return SourceTypes.getAll().get(id);
        }
    }
}

