/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.backpack.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.client.renderer.backpack.value.source.BaseSource;
import com.mrcrayfish.backpacked.client.renderer.backpack.value.source.StaticSource;
import java.util.function.Function;

public final class Value {
    public static final Value ZERO = new Value(new StaticSource(0.0), 0.0, 1.0);
    public static final Codec<Value> VALUE_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BaseSource.CODEC.fieldOf("source").forGetter(o -> o.source), (App)Codec.DOUBLE.optionalFieldOf("base", (Object)0.0).forGetter(o -> o.base), (App)Codec.DOUBLE.optionalFieldOf("multiplier", (Object)1.0).forGetter(o -> o.multiplier)).apply((Applicative)builder, Value::new));
    public static final Codec<Value> CODEC = Codec.either((Codec)Codec.DOUBLE, VALUE_CODEC).xmap(either -> (Value)either.map(val -> new Value(new StaticSource((double)val), 0.0, 1.0), Function.identity()), value -> {
        BaseSource patt1308$temp = value.source;
        if (patt1308$temp instanceof StaticSource) {
            StaticSource source = (StaticSource)patt1308$temp;
            return Either.left((Object)source.value());
        }
        return Either.right((Object)value);
    });
    private final BaseSource source;
    private final double multiplier;
    private final double base;

    public Value(BaseSource source, double base, double multiplier) {
        this.source = source;
        this.base = base;
        this.multiplier = multiplier;
    }

    public double getValue(BackpackRenderContext context) {
        return this.base + this.source.apply(context) * this.multiplier;
    }
}

