/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public enum ETFDirectory {
    DOES_NOT_EXIST(null),
    ETF(new String[]{"textures", "etf/random"}),
    OLD_OPTIFINE(new String[]{"textures/entity", "optifine/mob"}),
    OPTIFINE(new String[]{"textures", "optifine/random"}),
    VANILLA(null);

    private final String[] replaceStrings;

    private ETFDirectory(String[] replaceStrings) {
        this.replaceStrings = replaceStrings;
    }

    public static Object2ReferenceOpenHashMap<@NotNull ResourceLocation, @NotNull ETFDirectory> getCache() {
        return ETFManager.getInstance().ETF_DIRECTORY_CACHE;
    }

    @Nullable
    public static ResourceLocation getDirectoryVersionOf(@Nullable ResourceLocation vanillaIdentifier) {
        if (vanillaIdentifier == null) {
            return null;
        }
        ETFDirectory directory = ETFDirectory.getDirectoryOf(vanillaIdentifier);
        return switch (directory.ordinal()) {
            case 0 -> null;
            case 4 -> vanillaIdentifier;
            default -> ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, directory);
        };
    }

    @NotNull
    public static ETFDirectory getDirectoryOf(@NotNull ResourceLocation vanillaIdentifier) {
        Object2ReferenceOpenHashMap<@NotNull ResourceLocation, @NotNull ETFDirectory> cache = ETFDirectory.getCache();
        return (ETFDirectory)((Object)cache.computeIfAbsent((Object)vanillaIdentifier, ETFDirectory::findDirectoryOf));
    }

    @NotNull
    private static ETFDirectory findDirectoryOf(ResourceLocation vanillaIdentifier) {
        String path = vanillaIdentifier.m_135815_();
        ResourceManager resources = Minecraft.m_91087_().m_91098_();
        if (path.contains("etf/random/entity") && resources.m_213713_(vanillaIdentifier).isPresent()) {
            return ETF;
        }
        if (path.contains("optifine/random/entity") && resources.m_213713_(vanillaIdentifier).isPresent()) {
            return OPTIFINE;
        }
        if (path.contains("optifine/mob") && resources.m_213713_(vanillaIdentifier).isPresent()) {
            return OLD_OPTIFINE;
        }
        ObjectArrayList foundDirectories = new ObjectArrayList();
        if (resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, VANILLA)).isPresent()) {
            foundDirectories.add((Object)VANILLA);
        }
        if (resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, OLD_OPTIFINE)).isPresent()) {
            foundDirectories.add((Object)OLD_OPTIFINE);
        }
        if (resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, OPTIFINE)).isPresent()) {
            foundDirectories.add((Object)OPTIFINE);
        }
        if (resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, ETF)).isPresent()) {
            foundDirectories.add((Object)ETF);
        }
        if (foundDirectories.isEmpty()) {
            return DOES_NOT_EXIST;
        }
        if (foundDirectories.size() == 1) {
            return (ETFDirectory)((Object)foundDirectories.get(0));
        }
        Object2ReferenceOpenHashMap resourcePackNames = new Object2ReferenceOpenHashMap();
        for (ETFDirectory directory : foundDirectories) {
            resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, directory)).ifPresent(value -> resourcePackNames.put((Object)value.m_215506_(), (Object)directory));
        }
        String returnedPack = ETFUtils2.returnNameOfHighestPackFromTheseMultiple((String[])resourcePackNames.keySet().toArray((Object[])new String[0]));
        return returnedPack != null ? (ETFDirectory)((Object)resourcePackNames.get((Object)returnedPack)) : VANILLA;
    }

    @NotNull
    public static ResourceLocation getIdentifierAsDirectory(ResourceLocation identifier, ETFDirectory directory) {
        if (directory.doesReplace()) {
            return ETFUtils2.res(identifier.m_135827_(), identifier.m_135815_().replace(directory.replaceStrings[0], directory.replaceStrings[1]));
        }
        return identifier;
    }

    public boolean doesReplace() {
        return this.replaceStrings != null;
    }
}

