/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class BlockTypeRegistry<T extends BlockType> {
    protected boolean frozen = false;
    private final String name;
    private final List<BlockType.SetFinder<T>> finders = new ArrayList<BlockType.SetFinder<T>>();
    private final Set<ResourceLocation> notInclude = new HashSet<ResourceLocation>();
    private final MapRegistry<T> valuesReg;
    private final Class<T> typeClass;
    private final Object2ObjectOpenHashMap<Object, T> childrenToType = new Object2ObjectOpenHashMap();

    public static Codec<BlockTypeRegistry<?>> getRegistryCodec() {
        return BlockSetInternal.getRegistriesCodec();
    }

    protected BlockTypeRegistry(Class<T> typeClass, String name) {
        this.typeClass = typeClass;
        this.name = name;
        this.valuesReg = new MapRegistry(name);
    }

    public Class<T> getType() {
        return this.typeClass;
    }

    @Deprecated(forRemoval=true)
    public T getFromNBT(String name) {
        return (T)((BlockType)this.valuesReg.getValueOrDefault(new ResourceLocation(name), this.getDefaultType()));
    }

    @Nullable
    public T get(ResourceLocation res) {
        return (T)((BlockType)this.valuesReg.getValue(res));
    }

    public ResourceLocation getKey(T input) {
        return this.valuesReg.getKey(input);
    }

    public Codec<T> getCodec() {
        return this.valuesReg;
    }

    public abstract T getDefaultType();

    public Collection<T> getValues() {
        return this.valuesReg.getValues();
    }

    public String typeName() {
        return this.name;
    }

    public abstract Optional<T> detectTypeFromBlock(Block var1, ResourceLocation var2);

    public void registerBlockType(T newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a wood types after registry events");
        }
        if (!this.valuesReg.containsKey(((BlockType)newType).id)) {
            this.valuesReg.register(((BlockType)newType).id, newType);
        }
    }

    public Collection<BlockType.SetFinder<T>> getFinders() {
        return this.finders;
    }

    public void addFinder(BlockType.SetFinder<T> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a block type finder after registry events");
        }
        this.finders.add(finder);
    }

    public void addRemover(ResourceLocation id) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        this.notInclude.add(id);
    }

    protected void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        this.frozen = true;
    }

    @ApiStatus.Internal
    public void onBlockInit() {
        this.getValues().forEach(BlockType::initializeChildrenBlocks);
    }

    @ApiStatus.Internal
    public void onItemInit() {
        this.getValues().forEach(BlockType::initializeChildrenItems);
    }

    @ApiStatus.Internal
    public void buildAll() {
        if (!this.frozen) {
            T defaultType = this.getDefaultType();
            if (defaultType != null) {
                this.registerBlockType(defaultType);
            }
            this.finders.stream().map(BlockType.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
            for (Block b : BuiltInRegistries.f_256975_) {
                this.detectTypeFromBlock(b, Utils.getID(b)).ifPresent(t -> {
                    if (!this.notInclude.contains(t.getId())) {
                        this.registerBlockType(t);
                    }
                });
            }
            this.finders.clear();
            this.notInclude.clear();
            this.finalizeAndFreeze();
        }
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
    }

    @Nullable
    public T getBlockTypeOf(ItemLike itemLike) {
        BlockType t = (BlockType)this.childrenToType.get((Object)itemLike);
        if (t != null) {
            return (T)t;
        }
        if (itemLike == Items.f_41852_ || itemLike == Blocks.f_50016_) {
            return null;
        }
        if (itemLike instanceof BlockItem) {
            BlockItem bi = (BlockItem)itemLike;
            return (T)((BlockType)this.childrenToType.get((Object)bi.m_40614_()));
        }
        if (itemLike instanceof Block) {
            Block b = (Block)itemLike;
            Item item = b.m_5456_();
            if (item == Items.f_41852_) {
                return null;
            }
            return (T)((BlockType)this.childrenToType.get((Object)item));
        }
        return null;
    }

    protected void mapObjectToType(Object itemLike, BlockType type) {
        BlockItem bi;
        this.childrenToType.put(itemLike, (Object)type);
        if (itemLike instanceof BlockItem && !this.childrenToType.containsKey((Object)(bi = (BlockItem)itemLike).m_40614_())) {
            this.childrenToType.put((Object)bi.m_40614_(), (Object)type);
        }
    }

    public int priority() {
        return 100;
    }
}

