/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.data.model;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.data.model.PreparedVariantBlockState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.ArrayUtils;

public class PreparedMultiPartBlockState {
    private final Block block;
    private final List<Entry> entries = new ArrayList<Entry>();
    private PreparedVariantBlockState.Model itemModel;

    public PreparedMultiPartBlockState(Block block) {
        this.block = block;
    }

    public Block getBlock() {
        return this.block;
    }

    public Entry createPart() {
        Entry entry = Entry.of(this.block);
        this.entries.add(entry);
        return entry;
    }

    public List<Entry> getParts() {
        return this.entries;
    }

    public void setItemModel(PreparedVariantBlockState.Model itemModel) {
        this.itemModel = itemModel;
    }

    @Nullable
    public PreparedVariantBlockState.Model getModelForItem() {
        return this.itemModel;
    }

    public static class Entry {
        private final Block block;
        private final Map<Property, Comparable> map = new TreeMap<Property, Comparable>(Comparator.comparing(Property::m_61708_));
        private PreparedVariantBlockState.Model[] models = new PreparedVariantBlockState.Model[0];
        private boolean orMode;

        private Entry(Block block) {
            this.block = block;
        }

        public <T extends Comparable<T>> Entry prop(Property<T> key, T value) {
            Preconditions.checkArgument((boolean)this.block.m_49965_().m_61092_().contains(key));
            this.map.put(key, value);
            return this;
        }

        public Entry addExistingModel(PreparedVariantBlockState.Model builder) {
            this.models = (PreparedVariantBlockState.Model[])ArrayUtils.add((Object[])this.models, (Object)builder);
            return this;
        }

        public Entry addTexturedModel(PreparedVariantBlockState.Model builder) {
            builder.markAsChild();
            this.models = (PreparedVariantBlockState.Model[])ArrayUtils.add((Object[])this.models, (Object)builder);
            return this;
        }

        public Entry orMode() {
            this.orMode = true;
            return this;
        }

        public boolean isOrMode() {
            return this.orMode;
        }

        public PreparedVariantBlockState.Model[] getModels() {
            return this.models;
        }

        public Map<Property, Comparable> getValueMap() {
            return this.map;
        }

        public int hashCode() {
            return Objects.hash(this.block, this.map);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry that = (Entry)o;
            return this.block.equals(that.block);
        }

        public static Entry of(Block block) {
            return new Entry(block);
        }

        public boolean is(BlockState state) {
            return this.map.entrySet().stream().allMatch(entry -> Objects.equals(state.m_61143_((Property)entry.getKey()), entry.getValue()));
        }
    }
}

