/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ByteImage {
    private static final int BANDS = 4;
    private final byte[] bytes;
    private final int width;
    private final int height;

    public ByteImage(byte[] bytes, int width, int height) {
        this.bytes = bytes;
        this.width = width;
        this.height = height;
    }

    public ByteImage(int width, int height) {
        this.bytes = new byte[width * height * 4];
        this.width = width;
        this.height = height;
    }

    public static ByteImage read(InputStream stream) throws IOException {
        BufferedImage image = ImageIO.read(stream);
        if (image == null) {
            throw new IOException("Invalid file");
        }
        ByteImage byteImage = new ByteImage(image.getWidth(), image.getHeight());
        int[] data = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int d = data[y * image.getWidth() + x];
                byteImage.setPixel(x, y, d >> 16 & 0xFF, d >> 8 & 0xFF, d & 0xFF, d >> 24 & 0xFF);
            }
        }
        return byteImage;
    }

    public static ByteImage read(byte[] bytes) throws IOException {
        return ByteImage.read(new ByteArrayInputStream(bytes));
    }

    public BufferedImage toBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                bufferedImage.setRGB(x, y, this.getARGB(x, y));
            }
        }
        return bufferedImage;
    }

    public void write(File file) {
        try {
            ImageIO.write((RenderedImage)this.toBufferedImage(), "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encode() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.toBufferedImage(), "png", stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream.toByteArray();
    }

    public void setPixel(int x, int y, int r, int g, int b, int a) {
        this.setPixel(x, y, (byte)r, (byte)g, (byte)b, (byte)a);
    }

    public void setPixel(int x, int y, byte r, byte g, byte b, byte a) {
        int i = this.getIndex(x, y);
        this.bytes[i] = r;
        this.bytes[i + 1] = g;
        this.bytes[i + 2] = b;
        this.bytes[i + 3] = a;
    }

    public int getIndex(int x, int y) {
        return (x * this.height + y) * 4;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void getHSV(float[] hsv, int x, int y) {
        int index = this.getIndex(x, y);
        Color.RGBtoHSB(this.bytes[index] & 0xFF, this.bytes[index + 1] & 0xFF, this.bytes[index + 2] & 0xFF, hsv);
    }

    public void setHSV(int x, int y, float[] hsv) {
        int index = this.getIndex(x, y);
        byte r = 0;
        byte g = 0;
        byte b = 0;
        if (hsv[1] == 0.0f) {
            g = b = (byte)(hsv[2] * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hsv[0] - (float)Math.floor(hsv[0])) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = hsv[2] * (1.0f - hsv[1]);
            float q = hsv[2] * (1.0f - hsv[1] * f);
            float t = hsv[2] * (1.0f - hsv[1] * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (byte)(hsv[2] * 255.0f + 0.5f);
                    g = (byte)(t * 255.0f + 0.5f);
                    b = (byte)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (byte)(q * 255.0f + 0.5f);
                    g = (byte)(hsv[2] * 255.0f + 0.5f);
                    b = (byte)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (byte)(p * 255.0f + 0.5f);
                    g = (byte)(hsv[2] * 255.0f + 0.5f);
                    b = (byte)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (byte)(p * 255.0f + 0.5f);
                    g = (byte)(q * 255.0f + 0.5f);
                    b = (byte)(hsv[2] * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (byte)(t * 255.0f + 0.5f);
                    g = (byte)(p * 255.0f + 0.5f);
                    b = (byte)(hsv[2] * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (byte)(hsv[2] * 255.0f + 0.5f);
                    g = (byte)(p * 255.0f + 0.5f);
                    b = (byte)(q * 255.0f + 0.5f);
                }
            }
        }
        this.bytes[index] = r;
        this.bytes[index + 1] = g;
        this.bytes[index + 2] = b;
    }

    public int getARGB(int x, int y) {
        int index = this.getIndex(x, y);
        return this.bytes[index + 2] & 0xFF | (this.bytes[index + 1] & 0xFF) << 8 | (this.bytes[index] & 0xFF) << 16 | (this.bytes[index + 3] & 0xFF) << 24;
    }

    public int getABGR(int x, int y) {
        int index = this.getIndex(x, y);
        return this.bytes[index] & 0xFF | (this.bytes[index + 1] & 0xFF) << 8 | (this.bytes[index + 2] & 0xFF) << 16 | (this.bytes[index + 3] & 0xFF) << 24;
    }
}

