/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import dev.tr7zw.entityculling.CullTask;
import dev.tr7zw.entityculling.NMSCullingHelper;
import dev.tr7zw.entityculling.Provider;
import dev.tr7zw.entityculling.util.NMSHelper;
import dev.tr7zw.entityculling.versionless.EntityCullingVersionlessBase;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;

public abstract class EntityCullingModBase
extends EntityCullingVersionlessBase {
    public static EntityCullingModBase instance;
    public Set<BlockEntityType<?>> blockEntityWhitelist = new HashSet();
    public Set<EntityType<?>> entityWhistelist = new HashSet();
    public Set<EntityType<?>> tickCullWhistelist = new HashSet();
    public CullTask cullTask;
    protected KeyMapping keybind = new KeyMapping("key.entityculling.toggle", -1, "text.entityculling.title");
    private Set<Function<BlockEntity, Boolean>> dynamicBlockEntityWhitelist = new HashSet<Function<BlockEntity, Boolean>>();
    private Set<Function<Entity, Boolean>> dynamicEntityWhitelist = new HashSet<Function<Entity, Boolean>>();

    @Override
    public void onInitialize() {
        instance = this;
        super.onInitialize();
        this.culling = new OcclusionCullingInstance(this.config.tracingDistance, new Provider());
        this.cullTask = new CullTask(this.culling, this.blockEntityWhitelist, this.entityWhistelist);
        this.cullThread = new Thread((Runnable)this.cullTask, "CullThread");
        this.cullThread.setUncaughtExceptionHandler((thread, ex) -> LOGGER.error("The CullingThread has crashed! Please report the following stacktrace!", ex));
        this.initModloader();
    }

    public void worldTick() {
        this.cullTask.requestCull = true;
    }

    public void clientTick() {
        if (!this.lateInit) {
            Optional entity;
            this.lateInit = true;
            this.cullThread.start();
            for (String blockId : this.config.blockEntityWhitelist) {
                Optional block = BuiltInRegistries.f_257049_.m_6612_(NMSHelper.getResourceLocation(blockId));
                block.ifPresent(b -> this.blockEntityWhitelist.add((BlockEntityType<?>)b));
            }
            for (String entityType : this.config.tickCullingWhitelist) {
                entity = BuiltInRegistries.f_256780_.m_6612_(NMSHelper.getResourceLocation(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((EntityType<?>)e));
            }
            for (String entityType : this.config.entityWhitelist) {
                entity = BuiltInRegistries.f_256780_.m_6612_(NMSHelper.getResourceLocation(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((EntityType<?>)e));
            }
        }
        if (this.keybind.m_90857_()) {
            if (this.pressed) {
                return;
            }
            this.pressed = true;
            boolean bl = enabled = !enabled;
            if (enabled) {
                NMSCullingHelper.sendChatMessage((Component)Component.m_237113_((String)"Culling on").m_130940_(ChatFormatting.GREEN));
            } else {
                NMSCullingHelper.sendChatMessage((Component)Component.m_237113_((String)"Culling off").m_130940_(ChatFormatting.RED));
            }
        } else {
            this.pressed = false;
        }
        this.cullTask.requestCull = true;
    }

    public abstract AABB setupAABB(BlockEntity var1, BlockPos var2);

    public boolean isDynamicWhitelisted(BlockEntity entity) {
        for (Function<BlockEntity, Boolean> fun : this.dynamicBlockEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicWhitelisted(Entity entity) {
        for (Function<Entity, Boolean> fun : this.dynamicEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void addDynamicBlockEntityWhitelist(Function<BlockEntity, Boolean> function) {
        this.dynamicBlockEntityWhitelist.add(function);
    }

    public void addDynamicEntityWhitelist(Function<Entity, Boolean> function) {
        this.dynamicEntityWhitelist.add(function);
    }
}

