/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.nethervinery.core.block;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.nethervinery.core.block.entity.NetherStorageBlockEntity;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.WineYears;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetherDrinkBlockItem
extends BlockItem {
    private final int baseDuration;
    private final boolean scaleDurationWithAge;

    public NetherDrinkBlockItem(Block block, Item.Properties settings, int baseDuration, boolean scaleDurationWithAge) {
        super(block, settings);
        this.baseDuration = baseDuration;
        this.scaleDurationWithAge = scaleDurationWithAge;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    protected BlockState m_5965_(BlockPlaceContext context) {
        if (!Objects.requireNonNull(context.m_43723_()).m_6047_()) {
            return null;
        }
        BlockState blockState = this.m_40614_().m_5573_(context);
        return blockState != null && this.m_40610_(context, blockState) ? blockState : null;
    }

    protected boolean m_7274_(BlockPos blockPos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof NetherStorageBlockEntity) {
            NetherStorageBlockEntity wineEntity = (NetherStorageBlockEntity)blockEntity;
            wineEntity.setStack(0, itemStack.m_255036_(1));
        }
        return super.m_7274_(blockPos, level, player, itemStack, blockState);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        ArrayList effects;
        List list = effects = this.m_41473_() != null ? this.m_41473_().m_38749_() : Lists.newArrayList();
        if (effects.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (Pair effectPair : effects) {
                MobEffectInstance effectInstance = (MobEffectInstance)effectPair.getFirst();
                MobEffect effect = effectInstance.m_19544_();
                String effectName = effect.m_19482_().getString();
                int amplifier = WineYears.getEffectLevel((ItemStack)stack, (Level)world);
                String amplifierRoman = amplifier > 0 ? " " + this.toRoman(amplifier) : "";
                int durationTicks = this.scaleDurationWithAge ? WineYears.getEffectDuration((ItemStack)stack, (Level)world) : this.baseDuration;
                String formattedDuration = this.formatDuration(durationTicks);
                String tooltipText = effectName + amplifierRoman + " (" + formattedDuration + ")";
                tooltip.add((Component)Component.m_237113_((String)tooltipText).m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        tooltip.add((Component)Component.m_237119_());
        if (world != null) {
            int age = WineYears.getWineAge((ItemStack)stack, (Level)world);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.vinery.age", (Object[])new Object[]{age}).m_130940_(ChatFormatting.WHITE));
            tooltip.add((Component)Component.m_237119_());
            int yearsToNextUpgrade = WineYears.YEARS_PER_EFFECT_LEVEL - age % WineYears.YEARS_PER_EFFECT_LEVEL;
            int daysToNextUpgrade = yearsToNextUpgrade * WineYears.DAYS_PER_YEAR;
            tooltip.add((Component)Component.m_237110_((String)"tooltip.vinery.next_upgrade", (Object[])new Object[]{daysToNextUpgrade}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)9684093))));
        }
    }

    @NotNull
    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        super.m_5922_(itemStack, level, livingEntity);
        return GeneralUtil.convertStackAfterFinishUsing((LivingEntity)livingEntity, (ItemStack)itemStack, (Item)((Item)ObjectRegistry.WINE_BOTTLE.get()), (Item)this);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        super.m_7836_(stack, world, player);
        WineYears.setWineYear((ItemStack)stack, (Level)world);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (world != null && WineYears.hasWineYear((ItemStack)stack)) {
            WineYears.setWineYear((ItemStack)stack, (Level)world);
        }
    }

    private String toRoman(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> String.valueOf(number);
        };
    }

    private String formatDuration(int ticks) {
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%d:%02d", minutes, seconds);
    }
}

