/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.SkullRendererCache;
import dev.tr7zw.skinlayers.accessor.SkullModelAccessor;
import dev.tr7zw.skinlayers.accessor.SkullSettings;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.util.NMSHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SkullBlockRenderer.class})
public class SkullBlockEntityRendererMixin {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(SkullBlockEntity skullBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, CallbackInfo info) {
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        if (!SkinLayersModBase.config.enableSkulls) {
            return;
        }
        if (this.internalDistToCenterSqr(skullBlockEntity.m_58899_(), (int)camera.m_7096_(), (int)camera.m_7098_(), (int)camera.m_7094_()) < (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            SkullRendererCache.lastSkull = (SkullSettings)skullBlockEntity;
            GameProfile gameProfile = null;
            gameProfile = skullBlockEntity.m_59779_();
            if (gameProfile == null) {
                return;
            }
            ResourceLocation textureLocation = NMSHelper.getPlayerSkin(gameProfile);
            if (textureLocation != SkullRendererCache.lastSkull.getLastTexture()) {
                SkullRendererCache.lastSkull.setInitialized(false);
            }
            if (!SkullRendererCache.lastSkull.initialized() && SkullRendererCache.lastSkull.getHeadLayers() == null) {
                SkullRendererCache.lastSkull.setInitialized(true);
                SkullRendererCache.lastSkull.setLastTexture(textureLocation);
                SkinUtil.setup3dLayers(gameProfile, SkullRendererCache.lastSkull);
            }
            SkullRendererCache.renderNext = SkullRendererCache.lastSkull.getHeadLayers() != null;
        }
    }

    private double internalDistToCenterSqr(BlockPos pos, double d, double e, double f) {
        double g = (double)pos.m_123341_() + 0.5 - d;
        double h = (double)pos.m_123342_() + 0.5 - e;
        double i = (double)pos.m_123343_() + 0.5 - f;
        return g * g + h * h + i * i;
    }

    @Inject(method={"renderSkull"}, at={@At(value="HEAD")})
    private static void renderSkull(Direction direction, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, SkullModelBase skullModelBase, RenderType renderType, CallbackInfo ci) {
        if (skullModelBase instanceof SkullModelAccessor) {
            SkullModelAccessor accessor = (SkullModelAccessor)skullModelBase;
            if (!SkullRendererCache.renderNext || SkullRendererCache.lastSkull == null) {
                accessor.showHat(true);
                SkullRendererCache.lastSkull = null;
                return;
            }
            Mesh mesh = SkullRendererCache.lastSkull.getHeadLayers();
            if (mesh == null) {
                accessor.showHat(true);
                SkullRendererCache.lastSkull = null;
                return;
            }
            accessor.showHat(false);
            poseStack.m_85836_();
            if (direction == null) {
                poseStack.m_85837_(0.5, 0.0, 0.5);
            } else {
                float h = 0.25f;
                poseStack.m_252880_(0.5f - (float)direction.m_122429_() * h, h, 0.5f - (float)direction.m_122431_() * h);
            }
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            float voxelSize = SkinLayersModBase.config.skullVoxelSize;
            poseStack.m_85841_(voxelSize, voxelSize, voxelSize);
            mesh.setPosition(0.0f, -0.25f, 0.0f);
            mesh.setRotation(0.0f, f * ((float)Math.PI / 180), 0.0f);
            SkullRendererCache.lastSkull.getHeadLayers().render(poseStack, multiBufferSource.m_6299_(renderType), i, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            SkullRendererCache.renderNext = false;
            SkullRendererCache.lastSkull = null;
        }
    }
}

