/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.SiloBlock;
import net.satisfy.farm_and_charm.core.recipe.SiloRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.util.ConnectivityHandler;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import net.satisfy.farm_and_charm.core.util.IMultiBlockEntityContainer;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SiloBlockEntity
extends BlockEntity
implements IMultiBlockEntityContainer.Inventory,
ImplementedInventory,
MenuProvider,
BlockEntityTicker<SiloBlockEntity> {
    private static final int MAX_WIDTH = 3;
    private static final int MAX_HEIGHT = 9;
    public static final int MAX_CAPACITY = 81;
    private static final int DRY_TIME = 200;
    protected BlockPos controller;
    protected boolean updateConnectivity = false;
    protected int width = 1;
    protected int height = 1;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)162, (Object)ItemStack.f_41583_);
    private int[] times = new int[81];

    public SiloBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.SILO_BLOCK_ENTITY.get(), pos, state);
    }

    public static void dropStack(Level level, double x, double y, double z, ItemStack itemStack, Direction direction) {
        double g = EntityType.f_20461_.m_20678_();
        double h = 1.0 - g;
        double i = g / 2.0;
        double j = Math.floor(x) + level.f_46441_.m_188500_() * h + i;
        double k = Math.floor(y) + level.f_46441_.m_188500_() * h;
        double l = Math.floor(z) + level.f_46441_.m_188500_() * h + i;
        while (!itemStack.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(level, j, k, l, itemStack.m_41620_(level.f_46441_.m_188503_(21) + 10));
            itemEntity.m_20334_(level.f_46441_.m_216328_((double)direction.m_122429_() * 0.4, 0.11485000171139836), level.f_46441_.m_216328_(-0.2, 0.11485000171139836), level.f_46441_.m_216328_((double)direction.m_122431_() * 0.4, 0.11485000171139836));
            level.m_7967_((Entity)itemEntity);
        }
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.f_58858_.equals((Object)this.controller);
    }

    @Override
    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    @Override
    public void setController(BlockPos controller) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_ || controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)this);
    }

    @Override
    public <T extends BlockEntity> T getControllerBE() {
        if (this.isController()) {
            SiloBlockEntity result = this;
            return (T)result;
        }
        assert (this.f_58857_ != null);
        BlockEntity be = this.f_58857_.m_7702_(this.controller);
        if (be instanceof IMultiBlockEntityContainer) {
            BlockEntity result = be;
            return (T)result;
        }
        return null;
    }

    @Override
    public void removeController(boolean keepContents) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.width = 1;
        this.height = 1;
        BlockState state = this.m_58900_();
        if (SiloBlock.isSilo(state)) {
            state = (BlockState)state.m_61124_((Property)SiloBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)SiloBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_(SiloBlock.SHAPE, (Comparable)((Object)SiloBlock.Shape.NONE));
            this.f_58857_.m_7731_(this.f_58858_, state, 23);
        }
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, SiloBlockEntity blockEntity) {
        if (this.f_58857_ == null) {
            this.f_58857_ = level;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        this.dry();
        this.tryDropFinish(blockState);
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    public boolean tryAddItem(ItemStack itemStack) {
        boolean added = false;
        for (int slot = 0; !itemStack.m_41619_() && slot < this.getCapacity(); ++slot) {
            if (!this.m_8020_(slot).m_41619_()) continue;
            this.m_6836_(slot, itemStack.m_41620_(1));
            added = true;
        }
        return added;
    }

    public ItemStack tryRemoveItem() {
        for (int slot = 81 + this.getCapacity(); slot > 81; --slot) {
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_()) continue;
            return this.m_7407_(slot, stack.m_41613_());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (SiloBlock.isSilo(state) && this.f_58857_ != null) {
            state = (BlockState)state.m_61124_((Property)SiloBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().m_123342_() == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)SiloBlock.TOP, (Comparable)Boolean.valueOf(this.getController().m_123342_() + this.height - 1 == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)SiloBlock.OPEN, (Comparable)((Boolean)this.f_58857_.m_8055_(this.getController()).m_61143_((Property)BlockStateProperties.f_61446_)));
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)this.f_58857_.m_8055_(this.getController()).m_61143_((Property)BlockStateProperties.f_61374_)));
            this.f_58857_.m_7731_(this.f_58858_, state, 6);
        }
        if (this.isController()) {
            this.updateShape();
        }
    }

    public void updateShape() {
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    assert (this.f_58857_ != null);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!SiloBlock.isSilo(blockState)) continue;
                    SiloBlock.Shape shape = SiloBlock.Shape.NONE;
                    if (this.width == 2) {
                        SiloBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? SiloBlock.Shape.NORTH_WEST : SiloBlock.Shape.SOUTH_WEST) : (shape = zOffset == 0 ? SiloBlock.Shape.NORTH_EAST : SiloBlock.Shape.SOUTH_EAST);
                    }
                    if (this.width == 3) {
                        shape = switch (xOffset) {
                            case 0 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH_WEST;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH_WEST;
                                }
                                yield SiloBlock.Shape.WEST;
                            }
                            case 1 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH;
                                }
                                yield SiloBlock.Shape.NONE;
                            }
                            case 2 -> {
                                if (zOffset == 0) {
                                    yield SiloBlock.Shape.NORTH_EAST;
                                }
                                if (zOffset == 2) {
                                    yield SiloBlock.Shape.SOUTH_EAST;
                                }
                                yield SiloBlock.Shape.EAST;
                            }
                            default -> SiloBlock.Shape.NONE;
                        };
                    }
                    this.f_58857_.m_46597_(pos, (BlockState)blockState.m_61124_(SiloBlock.SHAPE, (Comparable)((Object)shape)));
                }
            }
        }
    }

    private void dry() {
        for (int fresh = 0; fresh < this.getCapacity(); ++fresh) {
            ItemStack freshStack = this.m_8020_(fresh);
            Optional<SiloRecipe> recipe = SiloBlock.getDryItemRecipe(this.f_58857_, freshStack);
            if (!recipe.isPresent() || freshStack.m_41619_()) continue;
            int dryTime = this.times[fresh];
            if (++dryTime >= 200) {
                for (int finish = 81; finish < 81 + this.getCapacity(); ++finish) {
                    if (!this.m_8020_(finish).m_41619_()) continue;
                    ItemStack finishStack = this.m_7407_(fresh, freshStack.m_41613_());
                    ItemStack outputStack = recipe.get().m_8043_(this.f_58857_.m_9598_()).m_255036_(finishStack.m_41613_());
                    this.m_6836_(finish, SiloBlock.isDryItem(this.f_58857_, finishStack) ? outputStack : finishStack);
                    dryTime = 0;
                    break;
                }
            }
            this.times[fresh] = dryTime;
        }
    }

    private void tryDropFinish(BlockState blockState) {
        if (this.f_58857_ == null || !((Boolean)blockState.m_61143_((Property)SiloBlock.OPEN)).booleanValue()) {
            return;
        }
        for (int finish = 81; finish < 81 + this.getCapacity(); ++finish) {
            ItemStack finishStack = this.m_8020_(finish);
            if (finishStack.m_41619_()) continue;
            Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
            double x = switch (direction) {
                case Direction.EAST -> this.width;
                case Direction.WEST -> 0.0;
                default -> (double)this.width / 2.0;
            };
            double z = switch (direction) {
                case Direction.NORTH -> 0.0;
                case Direction.SOUTH -> this.width;
                default -> (double)this.width / 2.0;
            };
            SiloBlockEntity.dropStack(this.f_58857_, (double)this.f_58858_.m_123341_() + x, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + z, finishStack, direction);
            return;
        }
    }

    public void open(boolean open) {
        if (!this.isController()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    assert (this.f_58857_ != null);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!SiloBlock.isSilo(blockState)) continue;
                    this.f_58857_.m_46597_(pos, (BlockState)blockState.m_61124_((Property)SiloBlock.OPEN, (Comparable)Boolean.valueOf(open)));
                }
            }
        }
    }

    @Override
    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    @Override
    public int getMaxLength(Direction.Axis longAxis, int width) {
        return longAxis.m_122479_() ? this.getMaxWidth() : 9;
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public int getCapacity() {
        return !this.isController() ? 0 : this.width * this.width * this.height;
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public boolean hasInventory() {
        return this.isController();
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (this.controller != null) {
            GeneralUtil.putBlockPos(compoundTag, this.controller);
        }
        compoundTag.m_128379_("Update", this.updateConnectivity);
        compoundTag.m_128405_("Width", this.width);
        compoundTag.m_128405_("Height", this.height);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        compoundTag.m_128385_("Times", this.times);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.controller = GeneralUtil.readBlockPos(compoundTag);
        this.updateConnectivity = !compoundTag.m_128441_("Update") || compoundTag.m_128471_("Update");
        this.width = compoundTag.m_128441_("Width") ? compoundTag.m_128451_("Width") : 1;
        this.height = compoundTag.m_128441_("Height") ? compoundTag.m_128451_("Height") : 1;
        this.items = NonNullList.m_122780_((int)162, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        this.times = compoundTag.m_128441_("Times") ? compoundTag.m_128465_("Times") : new int[81];
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237119_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return null;
    }
}

