/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodHelper;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import org.apache.commons.compress.utils.Lists;

public class EffectFoodBlockEntity
extends BlockEntity {
    public static final String STORED_EFFECTS_KEY = "StoredEffects";
    private List<Pair<MobEffectInstance, Float>> effects;

    public EffectFoodBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityTypeRegistry.EFFECT_FOOD_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public void addEffects(List<Pair<MobEffectInstance, Float>> effects) {
        List filteredEffects = effects.stream().filter(effectPair -> ((MobEffectInstance)effectPair.getFirst()).m_19544_() != MobEffects.f_19612_).collect(Collectors.toList());
        this.effects = filteredEffects;
    }

    public List<Pair<MobEffectInstance, Float>> getEffects() {
        return this.effects != null ? this.effects : Lists.newArrayList();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.effects = EffectFoodHelper.fromNbt(nbt != null ? nbt.m_128437_(STORED_EFFECTS_KEY, 10) : new ListTag());
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.effects == null) {
            return;
        }
        ListTag nbtList = new ListTag();
        for (Pair<MobEffectInstance, Float> effect : this.effects) {
            nbtList.add((Object)EffectFoodHelper.createNbt((short)MobEffect.m_19459_((MobEffect)((MobEffectInstance)effect.getFirst()).m_19544_()), effect));
        }
        nbt.m_128365_(STORED_EFFECTS_KEY, (Tag)nbtList);
    }
}

