/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.entity.MincerBlockEntity;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MincerBlock
extends BaseEntityBlock {
    public static final int CRANKS_NEEDED = 20;
    public static final IntegerProperty CRANK = IntegerProperty.m_61631_((String)"crank", (int)0, (int)32);
    public static final IntegerProperty CRANKED = IntegerProperty.m_61631_((String)"cranked", (int)0, (int)100);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.9375, (double)0.0625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0625, (double)0.3125, (double)0.5625, (double)0.375, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.375, (double)0.25, (double)0.625, (double)0.8125, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.4375, (double)0.3125, (double)0.9375, (double)0.75, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.8125, (double)0.3125, (double)0.5625, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public MincerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CRANK, (Comparable)Integer.valueOf(0))).m_61124_((Property)CRANKED, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CRANK, CRANKED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = level.m_7702_(pos);
        ItemStack playerStack = player.m_21120_(hand);
        if (entity instanceof MincerBlockEntity) {
            ItemParticleOption particleOption;
            ServerLevel serverWorld;
            MincerBlockEntity mincer = (MincerBlockEntity)entity;
            if (player.m_6144_()) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)mincer);
                return InteractionResult.SUCCESS;
            }
            ItemStack inputStack = mincer.m_8020_(mincer.INPUT_SLOT);
            int crank = (Integer)state.m_61143_((Property)CRANK);
            int cranked = (Integer)state.m_61143_((Property)CRANKED);
            if (!playerStack.m_41619_() && crank == 0) {
                if (player.m_7500_()) {
                    ItemStack playerStackCopy = playerStack.m_41777_();
                    playerStackCopy.m_41764_(playerStackCopy.m_41741_());
                    mincer.m_6836_(mincer.INPUT_SLOT, playerStackCopy);
                    return InteractionResult.SUCCESS;
                }
                if (mincer.m_7013_(mincer.INPUT_SLOT, playerStack)) {
                    if (inputStack.m_150930_(playerStack.m_41720_())) {
                        int countToTakeFromPlayer;
                        int countInPlayerHand = playerStack.m_41613_();
                        int insertableCount = inputStack.m_41741_() - inputStack.m_41613_();
                        for (countToTakeFromPlayer = 0; countToTakeFromPlayer < insertableCount && countToTakeFromPlayer < countInPlayerHand; ++countToTakeFromPlayer) {
                        }
                        inputStack.m_41764_(inputStack.m_41613_() + countToTakeFromPlayer);
                        mincer.m_6836_(mincer.INPUT_SLOT, inputStack);
                        playerStack.m_41774_(countToTakeFromPlayer);
                    } else if (inputStack.m_41619_()) {
                        inputStack = playerStack.m_41777_();
                        mincer.m_6836_(mincer.INPUT_SLOT, inputStack);
                        playerStack.m_41774_(playerStack.m_41613_());
                    }
                    return InteractionResult.SUCCESS;
                }
                if (level.m_5776_() && playerStack.m_41720_() instanceof BlockItem) {
                    return InteractionResult.m_19078_((boolean)level.m_5776_());
                }
            } else if (playerStack.m_41619_()) {
                if (cranked >= 20 && crank == 0) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)CRANKED, (Comparable)Integer.valueOf(0)), 3);
                    return InteractionResult.SUCCESS;
                }
                if (level instanceof ServerLevel) {
                    serverWorld = (ServerLevel)level;
                    for (ItemStack stack : mincer.m_7086_()) {
                        if (stack.m_41619_() || mincer.m_8020_(mincer.OUTPUT_SLOT) == stack) continue;
                        particleOption = new ItemParticleOption(ParticleTypes.f_123752_, stack);
                        serverWorld.m_8767_((ParticleOptions)particleOption, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.4, 3, 0.2, 0.1, 0.0, 0.1);
                    }
                }
                if (crank <= 6) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)CRANK, (Comparable)Integer.valueOf(10)), 3);
                    level.m_5594_(null, pos, (SoundEvent)SoundEventRegistry.MINCER_CRANKING.get(), SoundSource.BLOCKS, 1.0f, 2.5f);
                    return InteractionResult.SUCCESS;
                }
            }
            if (cranked >= 20 && crank == 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CRANKED, (Comparable)Integer.valueOf(0)), 3);
                return InteractionResult.SUCCESS;
            }
            if (level instanceof ServerLevel) {
                serverWorld = (ServerLevel)level;
                for (ItemStack stack : mincer.m_7086_()) {
                    if (stack.m_41619_() || mincer.m_8020_(mincer.OUTPUT_SLOT) == stack) continue;
                    particleOption = new ItemParticleOption(ParticleTypes.f_123752_, stack);
                    serverWorld.m_8767_((ParticleOptions)particleOption, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.4, 3, 0.2, 0.1, 0.0, 0.1);
                }
            }
            if (crank <= 6) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CRANK, (Comparable)Integer.valueOf(10)), 3);
                level.m_5594_(null, pos, (SoundEvent)SoundEventRegistry.MINCER_CRANKING.get(), SoundSource.BLOCKS, 0.05f, 2.5f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.m_8055_(pos.m_7495_()).m_60808_((BlockGetter)world, pos.m_7495_());
        Direction direction = Direction.UP;
        return Block.m_49918_((VoxelShape)shape, (Direction)direction);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (MenuProvider)tileEntity : null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MincerBlockEntity(pos, state);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof MincerBlockEntity) {
                MincerBlockEntity be = (MincerBlockEntity)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)be);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return MincerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.MINCER_BLOCK_ENTITY.get()), (world1, pos, state1, be) -> be.tick(world1, pos, state1, (MincerBlockEntity)be));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.farm_and_charm.canbeplaced").m_130940_(ChatFormatting.GRAY));
    }
}

