/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory.container;

import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.inventory.container.slot.BackpackSlot;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackContainerMenu
extends AbstractContainerMenu {
    public static final int MAX_COLUMNS = 13;
    public static final int MAX_ROWS = 7;
    private final Container backpackInventory;
    private final int cols;
    private final int rows;
    private final boolean owner;

    public BackpackContainerMenu(int id, Inventory playerInventory, int cols, int rows, boolean owner) {
        this(id, playerInventory, (Container)new SimpleContainer(Mth.m_14045_((int)cols, (int)1, (int)13) * Mth.m_14045_((int)rows, (int)1, (int)7)), cols, rows, owner);
    }

    public BackpackContainerMenu(int id, Inventory playerInventory, Container backpackContainer, int cols, int rows, boolean owner) {
        super((MenuType)ModContainers.BACKPACK.get(), id);
        int i;
        this.backpackInventory = backpackContainer;
        this.cols = Mth.m_14045_((int)cols, (int)1, (int)13);
        this.rows = Mth.m_14045_((int)rows, (int)1, (int)7);
        this.owner = owner;
        BackpackContainerMenu.m_38869_((Container)backpackContainer, (int)(this.cols * this.rows));
        backpackContainer.m_5856_(playerInventory.f_35978_);
        int playerInventoryOffset = this.rows * 18 + 17 + 14 + 1;
        int backpackSlotWidth = this.cols * 18;
        int minSlotWidth = 162;
        int backpackStartX = Math.max((minSlotWidth - backpackSlotWidth) / 2, 0);
        int inventoryStartX = Math.max((backpackSlotWidth - minSlotWidth) / 2, 0);
        for (int j = 0; j < rows; ++j) {
            for (int i2 = 0; i2 < cols; ++i2) {
                this.m_38897_(new BackpackSlot(backpackContainer, i2 + j * cols, 8 + backpackStartX + i2 * 18, 18 + j * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + inventoryStartX + j * 18, i * 18 + playerInventoryOffset));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + inventoryStartX + i * 18, playerInventoryOffset + 58));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.backpackInventory.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack copy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            copy = slotStack.m_41777_();
            if (index < this.rows * this.cols ? !this.m_38903_(slotStack, this.rows * this.cols, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.rows * this.cols, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return copy;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.backpackInventory.m_5785_(playerIn);
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isOwner() {
        return this.owner;
    }
}

