/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.mixin.rendering.arrows;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_model_features.models.IEMFModel;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPartRoot;

@Mixin(value={StuckInBodyLayer.class})
public abstract class MixinStuckArrowsFeatureRenderer<T extends LivingEntity, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    public MixinStuckArrowsFeatureRenderer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    @Shadow
    protected abstract int m_7040_(T var1);

    @Shadow
    protected abstract void m_5558_(PoseStack var1, MultiBufferSource var2, int var3, Entity var4, float var5, float var6, float var7, float var8);

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void emf$start(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        EMFAnimationEntityContext.is_in_ground_override = true;
        if (((IEMFModel)this.m_117386_()).emf$isEMFModel()) {
            ci.cancel();
            EMFModelPartRoot root = ((IEMFModel)this.m_117386_()).emf$getEMFRootModel();
            int i = this.m_7040_(livingEntity);
            RandomSource randomSource = RandomSource.m_216335_((long)livingEntity.m_19879_());
            if (i > 0) {
                for (int j = 0; j < i; ++j) {
                    Random partRand = new Random(j);
                    poseStack.m_85836_();
                    Pair<ModelPart, Runnable> modelPart = this.emf$bestFromListMutable(new ArrayList<ModelPart>(root.getAllVanillaPartsEMF()), partRand, poseStack, true);
                    if (modelPart == null) {
                        EMFAnimationEntityContext.is_in_ground_override = false;
                        poseStack.m_85849_();
                        return;
                    }
                    ((Runnable)modelPart.getSecond()).run();
                    float f = randomSource.m_188501_();
                    float g = randomSource.m_188501_();
                    float h = randomSource.m_188501_();
                    if (!((ModelPart)modelPart.getFirst()).f_104212_.isEmpty()) {
                        ModelPart.Cube cube = ((ModelPart)modelPart.getFirst()).m_233558_(randomSource);
                        float k = Mth.m_14179_((float)f, (float)cube.f_104335_, (float)cube.f_104338_) / 16.0f;
                        float l = Mth.m_14179_((float)g, (float)cube.f_104336_, (float)cube.f_104339_) / 16.0f;
                        float m = Mth.m_14179_((float)h, (float)cube.f_104337_, (float)cube.f_104340_) / 16.0f;
                        poseStack.m_252880_(k, l, m);
                    }
                    f = -1.0f * (f * 2.0f - 1.0f);
                    g = -1.0f * (g * 2.0f - 1.0f);
                    h = -1.0f * (h * 2.0f - 1.0f);
                    this.m_5558_(poseStack, buffer, packedLight, (Entity)livingEntity, f, g, h, partialTicks);
                    poseStack.m_85849_();
                }
            }
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/LivingEntity;FFFFFF)V"}, at={@At(value="RETURN")})
    private void emf$end(CallbackInfo ci) {
        EMFAnimationEntityContext.is_in_ground_override = false;
    }

    @Unique
    @Nullable
    private Pair<ModelPart, Runnable> emf$bestFromListMutable(List<ModelPart> partsMutable, Random randomSource, PoseStack poseStack, boolean firstIteration) {
        Collections.shuffle(partsMutable, randomSource);
        for (ModelPart modelPart : partsMutable) {
            Pair<ModelPart, Runnable> child;
            if (!modelPart.f_104207_) continue;
            if (!modelPart.f_104212_.isEmpty() && !modelPart.f_233556_) {
                return Pair.of((Object)modelPart, () -> modelPart.m_104299_(poseStack));
            }
            if (modelPart.f_104213_.isEmpty() || (child = this.emf$bestFromListMutable(new ArrayList<ModelPart>(modelPart.f_104213_.values()), randomSource, poseStack, false)) == null) continue;
            Runnable runnable = (Runnable)child.getSecond();
            return Pair.of((Object)((ModelPart)child.getFirst()), () -> {
                modelPart.m_104299_(poseStack);
                runnable.run();
            });
        }
        if (firstIteration && !partsMutable.isEmpty()) {
            ModelPart part = partsMutable.get(0);
            return Pair.of((Object)part, () -> part.m_104299_(poseStack));
        }
        return null;
    }
}

