/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedSlicedStairsBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedSlicedStairsBlock
extends AbstractFramedDoubleBlock {
    private final boolean panel;

    public FramedSlicedStairsBlock(BlockType type) {
        super(type);
        this.panel = type == BlockType.FRAMED_SLICED_STAIRS_PANEL;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withTop()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedSlicedStairsBlockEntity(pos, state);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (this.panel || !((Boolean)state.m_61143_((Property)FramedProperties.TOP)).booleanValue()) {
            return DoubleBlockTopInteractionMode.EITHER;
        }
        return DoubleBlockTopInteractionMode.FIRST;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (this.panel) {
            return new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_())).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))));
        }
        return new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB.get()).m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))));
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction dirTwo;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (this.panel) {
            if (side == dir) {
                return SolidityCheck.FIRST;
            }
            if (side == dirTwo) {
                return SolidityCheck.BOTH;
            }
        } else {
            if (side == dirTwo) {
                return SolidityCheck.FIRST;
            }
            if (side == dir) {
                return SolidityCheck.BOTH;
            }
        }
        return SolidityCheck.NONE;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (this.panel) {
            if (side == dir || side.m_122434_() != dir.m_122434_() && edge == dir) {
                return CamoGetter.FIRST;
            }
            if (side == dirTwo && edge == dir.m_122424_()) {
                return CamoGetter.SECOND;
            }
            if (side == dir.m_122424_() && edge == dirTwo) {
                return CamoGetter.SECOND;
            }
        } else {
            if (side == dirTwo || side.m_122434_() != Direction.Axis.Y && edge == dirTwo) {
                return CamoGetter.FIRST;
            }
            if (side == dir && edge == dirTwo.m_122424_()) {
                return CamoGetter.SECOND;
            }
            if (side == dirTwo.m_122424_() && edge == dir) {
                return CamoGetter.SECOND;
            }
        }
        return CamoGetter.NONE;
    }

    public static BlockState itemModelSourceSlab() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_SLICED_STAIRS_SLAB.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    public static BlockState itemModelSourcePanel() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_SLICED_STAIRS_PANEL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

