/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedLatticeBlock
extends FramedBlock {
    private final BiPredicate<Direction, BlockState> connectionTest;

    public FramedLatticeBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false)));
        this.connectionTest = switch (type) {
            case BlockType.FRAMED_LATTICE_BLOCK -> FramedLatticeBlock::canConnectThin;
            case BlockType.FRAMED_THICK_LATTICE -> FramedLatticeBlock::canConnectThick;
            default -> throw new IllegalArgumentException("Unexpected lattice type: " + type);
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.X_AXIS, FramedProperties.Y_AXIS, FramedProperties.Z_AXIS, BlockStateProperties.f_61362_, FramedProperties.STATE_LOCKED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            BlockPos pos;
            Level level = modCtx.m_43725_();
            state = (BlockState)state.m_61124_((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)level, pos = modCtx.m_8083_(), Direction.EAST) || this.canConnectTo((LevelAccessor)level, pos, Direction.WEST)));
            state = (BlockState)state.m_61124_((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)level, pos, Direction.UP) || this.canConnectTo((LevelAccessor)level, pos, Direction.DOWN)));
            state = (BlockState)state.m_61124_((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)level, pos, Direction.NORTH) || this.canConnectTo((LevelAccessor)level, pos, Direction.SOUTH)));
            return state;
        })).withWater()).build();
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!((Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            Direction opposite = facing.m_122424_();
            state = (BlockState)state.m_61124_((Property)FramedLatticeBlock.getPropFromAxis(facing), (Comparable)Boolean.valueOf(this.canConnectTo(facingState, facing) || this.canConnectTo(level, pos, opposite)));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    private boolean canConnectTo(LevelAccessor level, BlockPos pos, Direction side) {
        BlockState state = level.m_8055_(pos.m_121945_(side));
        return this.canConnectTo(state, side);
    }

    private boolean canConnectTo(BlockState state, Direction side) {
        return state.m_60713_((Block)this) || this.connectionTest.test(side, state);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot != Rotation.NONE && rot != Rotation.CLOCKWISE_180) {
            boolean xAxis = (Boolean)state.m_61143_((Property)FramedProperties.Z_AXIS);
            boolean zAxis = (Boolean)state.m_61143_((Property)FramedProperties.X_AXIS);
            return (BlockState)((BlockState)state.m_61124_((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(xAxis))).m_61124_((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(zAxis));
        }
        return state;
    }

    public static BlockState itemModelSourceThin() {
        return (BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_LATTICE.get()).m_49966_().m_61124_((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(true));
    }

    public static BooleanProperty getPropFromAxis(Direction dir) {
        return switch (dir.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> FramedProperties.X_AXIS;
            case Direction.Axis.Y -> FramedProperties.Y_AXIS;
            case Direction.Axis.Z -> FramedProperties.Z_AXIS;
        };
    }

    private static boolean canConnectThin(Direction side, BlockState state) {
        if (state.m_60713_((Block)FBContent.BLOCK_FRAMED_POST.get())) {
            return side.m_122434_() == state.m_61143_((Property)BlockStateProperties.f_61365_);
        }
        return Utils.isY(side) && state.m_204336_(BlockTags.f_13039_);
    }

    private static boolean canConnectThick(Direction side, BlockState state) {
        if (state.m_204336_(BlockTags.f_13032_)) {
            return side == Direction.DOWN || side == Direction.UP && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_) != false;
        }
        if (state.m_60713_((Block)FBContent.BLOCK_FRAMED_PILLAR.get())) {
            return side.m_122434_() == state.m_61143_((Property)BlockStateProperties.f_61365_);
        }
        if (state.m_60713_((Block)FBContent.BLOCK_FRAMED_HALF_PILLAR.get())) {
            return side == ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
        }
        return false;
    }
}

