/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.cube.FramedOneWayWindowBlock;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.NullableDirection;

public final class OneWayWindowOverlay
extends BlockInteractOverlay {
    private static final ResourceLocation SYMBOL_TEXTURE = Utils.rl("textures/overlay/one_way_window_symbols.png");
    private static final ResourceLocation EYE_TEXTURE = new ResourceLocation("textures/item/ender_eye.png");
    private static final BlockInteractOverlay.Texture TEXTURE_BG = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 0, 0, 22, 38, 37, 38);
    private static final BlockInteractOverlay.Texture TEXTURE_CROSS = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 22, 0, 15, 15, 37, 38);
    private static final BlockInteractOverlay.Texture TEXTURE_EYE = new BlockInteractOverlay.Texture(EYE_TEXTURE, 0, 0, 16, 16, 16, 16);
    public static final String LINE_CURR_FACE = Utils.translationKey("tooltip", "one_way_window.curr_face");
    public static final String LINE_SET_FACE = Utils.translationKey("tooltip", "one_way_window.set_face");
    public static final Component LINE_CLEAR_FACE = Utils.translate("tooltip", "one_way_window.clear_face");
    public static final Component[] DIR_VALUE_LINES = Utils.buildEnumTranslations((String)"tooltip", (String)"one_way_window.dir", (Enum[])Direction.values(), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GOLD});
    public static final Component[] FACE_VALUE_LINES = Utils.buildEnumTranslations((String)"tooltip", (String)"one_way_window.face", (Enum[])NullableDirection.values(), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GOLD});
    public static final Component[] FACE_VALUE_ABBRS = Utils.buildEnumTranslations((String)"tooltip", (String)"one_way_window.face_abbr", (Enum[])NullableDirection.values(), (ChatFormatting[])new ChatFormatting[0]);
    private static final Component[] CURR_FACE_LINES = Utils.bindEnumTranslation((String)LINE_CURR_FACE, (Enum[])NullableDirection.values(), (Component[])FACE_VALUE_LINES);
    private static final Component[] SET_FACE_LINES = Utils.bindEnumTranslation((String)LINE_SET_FACE, (Enum[])Direction.values(), (Component[])DIR_VALUE_LINES);
    private static final List<Component> LINES = OneWayWindowOverlay.packLineList();

    public OneWayWindowOverlay() {
        super(LINES, List.of(), null, null, () -> ClientConfig.oneWayWindowMode);
    }

    @Override
    protected boolean isValidTool(ItemStack stack) {
        return stack.m_150930_((Item)FBContent.ITEM_FRAMED_WRENCH.get());
    }

    @Override
    protected boolean isValidTarget(BlockInteractOverlay.Target target) {
        if (target.state().m_60734_() != FBContent.BLOCK_FRAMED_ONE_WAY_WINDOW.get()) {
            return false;
        }
        return FramedOneWayWindowBlock.isOwnedBy(OneWayWindowOverlay.level(), target.pos(), OneWayWindowOverlay.player());
    }

    @Override
    protected boolean getState(BlockInteractOverlay.Target target) {
        return false;
    }

    @Override
    protected BlockInteractOverlay.Texture getTexture(BlockInteractOverlay.Target target, boolean state, BlockInteractOverlay.Texture texFalse, BlockInteractOverlay.Texture texTrue) {
        return TEXTURE_BG;
    }

    @Override
    protected List<Component> getLines(BlockInteractOverlay.Target target, boolean state, List<Component> linesFalse, List<Component> linesTrue) {
        NullableDirection face = (NullableDirection)((Object)target.state().m_61143_(PropertyHolder.NULLABLE_FACE));
        return List.of(CURR_FACE_LINES[face.ordinal()], SET_FACE_LINES[target.side().ordinal()], LINE_CLEAR_FACE);
    }

    @Override
    protected void renderAfterIcon(ForgeGui gui, GuiGraphics graphics, BlockInteractOverlay.Texture tex, int texX, int texY, BlockInteractOverlay.Target target) {
        NullableDirection face = (NullableDirection)((Object)target.state().m_61143_(PropertyHolder.NULLABLE_FACE));
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(-0.5, -0.5, 0.0);
        TEXTURE_EYE.draw(gui, graphics, texX + 3, texY + 3);
        if (face == NullableDirection.NONE) {
            TEXTURE_CROSS.draw(gui, graphics, texX + 4, texY + 4);
        }
        graphics.m_280168_().m_85849_();
        int x = texX + tex.width() / 2;
        int n = texY + tex.height() * 3 / 4;
        Objects.requireNonNull(gui.m_93082_());
        int y = n - 9 / 2;
        graphics.m_280653_(gui.m_93082_(), FACE_VALUE_ABBRS[face.ordinal()], x, y, -1);
    }

    private static List<Component> packLineList() {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add(LINE_CLEAR_FACE);
        lines.addAll(Arrays.asList(CURR_FACE_LINES));
        lines.addAll(Arrays.asList(SET_FACE_LINES));
        return lines;
    }
}

