/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.blockentity.special.FramedItemFrameBlockEntity;

public class FramedItemFrameRenderer
implements BlockEntityRenderer<FramedItemFrameBlockEntity> {
    private static final double ITEM_Z_OFF = 0.4375;
    private static final float DIR_OFF_MULT = 0.49875f;
    private static final float MAP_SCALE = 0.0078125f;
    private static final double MAX_NAMETAG_DIST_SQR = 4096.0;
    private final ItemRenderer itemRenderer;

    public FramedItemFrameRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.m_234447_();
    }

    public void render(FramedItemFrameBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        float yRot;
        poseStack.m_85836_();
        Direction dir = ((Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
        float dirOff = Utils.isPositive(dir) ? 0.0f : 1.0f;
        poseStack.m_252880_((float)dir.m_122429_() * 0.49875f + (Utils.isX(dir) ? dirOff : 0.5f), (float)dir.m_122430_() * 0.49875f + (Utils.isY(dir) ? dirOff : 0.5f), (float)dir.m_122431_() * 0.49875f + (Utils.isZ(dir) ? dirOff : 0.5f));
        boolean vert = Utils.isY(dir);
        float f = yRot = vert ? 0.0f : dir.m_122435_();
        if (vert) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f * (float)dir.m_122421_().m_122540_()));
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yRot));
        ItemStack item = be.getItem();
        MapItemSavedData mapData = MapItem.m_42853_((ItemStack)item, (Level)be.m_58904_());
        poseStack.m_85837_(0.0, 0.0, 0.4375);
        float itemRotation = mapData != null ? (float)(be.getRotation() % 4 * 2) : (float)be.getRotation();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(itemRotation * 360.0f / 8.0f));
        if (mapData != null) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
            poseStack.m_85837_(-64.0, -64.0, -1.0);
            int mapLight = be.isGlowingFrame() ? 15728850 : packedLight;
            int mapId = MapItem.m_151131_((ItemStack)item);
            Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(poseStack, buffer, mapId, mapData, true, mapLight);
        } else {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            int itemLight = be.isGlowingFrame() ? 0xF000F0 : packedLight;
            this.itemRenderer.m_269128_(item, ItemDisplayContext.FIXED, itemLight, OverlayTexture.f_118083_, poseStack, buffer, be.m_58904_(), 0);
        }
        poseStack.m_85849_();
        FramedItemFrameRenderer.renderCustomItemName(be, poseStack, buffer, packedLight);
    }

    private static void renderCustomItemName(FramedItemFrameBlockEntity be, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        ItemStack stack = be.getItem();
        if (!Minecraft.m_91404_() || stack.m_41619_() || !stack.m_41788_()) {
            return;
        }
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        if (!be.m_58899_().equals((Object)hitResult2.m_82425_())) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        double dist = camera.m_90583_().m_82557_(hitResult2.m_82450_());
        if (dist > 4096.0) {
            return;
        }
        Direction dir = (Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        float dx = 0.5f + (float)dir.m_122429_() * 0.46875f - (float)dir.m_122429_() * 0.3f;
        float dz = 0.5f + (float)dir.m_122431_() * 0.46875f - (float)dir.m_122431_() * 0.3f;
        poseStack.m_85836_();
        poseStack.m_252880_(dx, 1.25f, dz);
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Font font = Minecraft.m_91087_().f_91062_;
        Component name = stack.m_41786_();
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        int alpha = (int)(Minecraft.m_91087_().f_91066_.m_92141_(0.25f) * 255.0f) << 24;
        float x = (float)(-font.m_92852_((FormattedText)name)) / 2.0f;
        font.m_272077_(name, x, 0.0f, 0x20FFFFFF, false, pose, buffer, Font.DisplayMode.SEE_THROUGH, alpha, packedLight);
        font.m_272077_(name, x, 0.0f, -1, false, pose, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.m_85849_();
    }

    public boolean shouldRender(FramedItemFrameBlockEntity be, Vec3 cameraPos) {
        return be.hasItem() && super.m_142756_((BlockEntity)be, cameraPos);
    }
}

