/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.ApiStatus;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeReloader;

public final class ReloadableShapeProvider
implements ShapeProvider {
    private final ShapeGenerator generator;
    private final ImmutableList<BlockState> states;
    private ShapeProvider wrapped;

    public ReloadableShapeProvider(ShapeGenerator generator, ImmutableList<BlockState> states) {
        Preconditions.checkState((!FMLEnvironment.production ? 1 : 0) != 0, (Object)"Reloading shapes is not supported in production");
        this.generator = generator;
        this.states = states;
        this.wrapped = generator.generate(states);
        ShapeReloader.addProvider(this);
    }

    @Override
    public VoxelShape get(BlockState state) {
        return this.wrapped.get(state);
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public void forEach(BiConsumer<BlockState, VoxelShape> consumer) {
        this.wrapped.forEach(consumer);
    }

    @ApiStatus.Internal
    void reload() {
        this.wrapped = this.generator.generate(this.states);
    }
}

