/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.predicate.contex.ConTexMode;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;

@ApiStatus.Internal
public final class AppearanceHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();

    public static BlockState getAppearance(IFramedBlock framedBlock, BlockState state, BlockGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return AppearanceHelper.getAppearance(framedBlock, state, level, pos, side, queryState, queryPos, false);
    }

    private static BlockState getAppearance(IFramedBlock framedBlock, BlockState state, BlockGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos, boolean recursive) {
        Direction conEdge;
        IBlockType type = framedBlock.getBlockType();
        if (!FMLEnvironment.dist.isClient() || !type.supportsConnectedTextures()) {
            return AIR;
        }
        ConTexMode cfgMode = FramedBlocksClientAPI.getInstance().getConTexMode();
        if (cfgMode == ConTexMode.NONE || queryPos == null) {
            return AIR;
        }
        BlockState actualQueryState = AppearanceHelper.findApplicableNeighbor(level, queryPos, queryState);
        if (actualQueryState == AIR) {
            return AIR;
        }
        Direction edge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, $ -> true);
        StateCache stateCache = framedBlock.getCache(state);
        if (type.isDoubleBlock()) {
            if (recursive) {
                LOGGER.error("AppearanceHelper#getAppearance() trying to recurse multiple times, this is a bug. Please report this to FramedBlocks with the following stacktrace. Pos: {}, State: {}, Side: {}", new Object[]{pos, state, side, new Throwable()});
                return AIR;
            }
            if (actualQueryState != null) {
                if (AppearanceHelper.isNotFramedOrCanConnectFullEdgeTo(pos, queryPos, actualQueryState, side, edge)) {
                    if (!stateCache.canConnectFullEdge(side, edge)) {
                        return AIR;
                    }
                    BlockState componentState = framedBlock.getComponentAtEdge(level, pos, state, side, edge);
                    if (componentState == null) {
                        return AIR;
                    }
                    FramedBlockData modelData = AppearanceHelper.getModelData(level, pos, componentState, false);
                    return modelData != null ? modelData.getCamoState() : AIR;
                }
                if (edge == null) {
                    return AIR;
                }
                BlockState componentState = framedBlock.getComponentBySkipPredicate(level, pos, state, actualQueryState, edge);
                if (componentState != null) {
                    IFramedBlock componentBlock = (IFramedBlock)componentState.m_60734_();
                    return AppearanceHelper.getAppearance(componentBlock, componentState, level, pos, side, actualQueryState, queryPos, true);
                }
            }
            return AIR;
        }
        FramedBlockData modelData = AppearanceHelper.getModelData(level, pos, state, true);
        if (modelData == null) {
            return AIR;
        }
        ConTexMode typeMode = framedBlock.getBlockType().getMinimumConTexMode();
        if (AppearanceHelper.canUseMode(cfgMode, typeMode, ConTexMode.FULL_FACE) && stateCache.canConnectFullEdge(side, null)) {
            if (AppearanceHelper.isNotFramedOrCanConnectFullEdgeTo(pos, queryPos, actualQueryState, side, edge)) {
                return modelData.getCamoState();
            }
            return AIR;
        }
        if (edge == null) {
            return AIR;
        }
        if (AppearanceHelper.canUseMode(cfgMode, typeMode, ConTexMode.FULL_EDGE) && (conEdge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, testEdge -> stateCache.canConnectFullEdge(side, (Direction)testEdge))) != null) {
            return modelData.getCamoState();
        }
        if (cfgMode == ConTexMode.DETAILED && !queryPos.equals((Object)pos)) {
            Direction detEdge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, modelData::isSideHidden);
            if (detEdge != null && stateCache.canConnectDetailed(side, detEdge)) {
                return modelData.getCamoState();
            }
        }
        return AIR;
    }

    private static boolean canUseMode(ConTexMode cfgMode, ConTexMode typeMode, ConTexMode targetMode) {
        return cfgMode.atleast(targetMode) && targetMode.atleast(typeMode);
    }

    private static Direction findFirstSuitableDirectionFromOffset(BlockPos pos, BlockPos queryPos, Direction side, Predicate<Direction> pred) {
        int nz;
        int ny;
        if (pos.equals((Object)queryPos)) {
            return null;
        }
        int nx = queryPos.m_123341_() - pos.m_123341_();
        Direction conFace = Utils.dirByNormal(nx, ny = queryPos.m_123342_() - pos.m_123342_(), nz = queryPos.m_123343_() - pos.m_123343_());
        if (conFace != null) {
            return pred.test(conFace) ? conFace : null;
        }
        if (!Utils.isX(side) && (conFace = Utils.dirByNormal(nx, 0, 0)) != null && pred.test(conFace)) {
            return conFace;
        }
        if (!Utils.isY(side) && (conFace = Utils.dirByNormal(0, ny, 0)) != null && pred.test(conFace)) {
            return conFace;
        }
        if (!Utils.isZ(side) && (conFace = Utils.dirByNormal(0, 0, nz)) != null && pred.test(conFace)) {
            return conFace;
        }
        return null;
    }

    private static BlockState findApplicableNeighbor(BlockGetter level, BlockPos queryPos, @Nullable BlockState queryState) {
        Block block;
        if (queryState != null && (block = queryState.m_60734_()) instanceof IFramedBlock) {
            IFramedBlock queryBlock = (IFramedBlock)block;
            IBlockType type = queryBlock.getBlockType();
            if (type.isDoubleBlock()) {
                return null;
            }
            return type.supportsConnectedTextures() ? queryState : AIR;
        }
        if (queryState == null) {
            BlockState actualQueryState = level.m_8055_(queryPos);
            Block block2 = actualQueryState.m_60734_();
            if (block2 instanceof IFramedBlock) {
                IFramedBlock queryBlock = (IFramedBlock)block2;
                IBlockType type = queryBlock.getBlockType();
                if (type.isDoubleBlock()) {
                    return null;
                }
                if (!type.supportsConnectedTextures()) {
                    return AIR;
                }
                return actualQueryState;
            }
            queryState = actualQueryState;
        }
        return queryState.m_60795_() ? null : queryState;
    }

    private static boolean isNotFramedOrCanConnectFullEdgeTo(BlockPos pos, BlockPos queryPos, BlockState queryState, Direction side, @Nullable Direction edge) {
        Block block;
        if (queryState != null && (block = queryState.m_60734_()) instanceof IFramedBlock) {
            IFramedBlock queryBlock = (IFramedBlock)block;
            int nx = queryPos.m_123341_() - pos.m_123341_();
            int ny = queryPos.m_123342_() - pos.m_123342_();
            int nz = queryPos.m_123343_() - pos.m_123343_();
            if (side.m_122434_().m_7863_(nx, ny, nz) != 0) {
                side = side.m_122424_();
            }
            if (edge != null) {
                edge = edge.m_122424_();
            }
            return queryBlock.getCache(queryState).canConnectFullEdge(side, edge);
        }
        return true;
    }

    private static FramedBlockData getModelData(BlockGetter level, BlockPos pos, BlockState componentState, boolean mayBeSingle) {
        FramedBlockData fbData;
        ModelDataManager manager = level.getModelDataManager();
        if (manager == null) {
            return null;
        }
        ModelData data = manager.getAt(pos);
        if (data == null) {
            return null;
        }
        if (mayBeSingle && (fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY)) != null) {
            return fbData;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IFramedBlock) {
            IFramedBlock block2 = (IFramedBlock)block;
            return (FramedBlockData)block2.unpackNestedModelData(data, state, componentState).get(FramedBlockData.PROPERTY);
        }
        return null;
    }

    private AppearanceHelper() {
    }
}

