/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.registry;

import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DesiresTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return DesiresTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return DesiresTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return DesiresTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return DesiresTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void init() {
        AllBlockTags.init();
        AllItemTags.init();
        AllFluidTags.init();
        DesiresEntityTags.init();
        DesiresRecipeSerializerTags.init();
    }

    public static enum AllBlockTags {
        FAN_PROCESSING_CATALYSTS_SANDING(NameSpace.MOD, "fan_processing_catalysts/sanding"),
        FAN_PROCESSING_CATALYSTS_FREEZING(NameSpace.MOD, "fan_processing_catalysts/freezing"),
        FAN_PROCESSING_CATALYSTS_SEETHING(NameSpace.MOD, "fan_processing_catalysts/seething"),
        INDUSTRIAL_FAN_HEATER,
        INDUSTRIAL_FAN_TRANSPARENT,
        BACKPACKS;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? DesiresTags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllItemTags {
        SEETHABLE,
        SANDABLE,
        FREEZABLE,
        ADDITIONAL_DROPS_TOOL,
        MAGNET_IGNORE,
        SWORD(NameSpace.FORGE, "tools/sword"),
        PICKAXE(NameSpace.FORGE, "tools/pickaxe"),
        DRILL(NameSpace.FORGE, "tools/drill"),
        AXE(NameSpace.FORGE, "tools/axe"),
        SAW(NameSpace.FORGE, "tools/saw"),
        SHOVEL(NameSpace.FORGE, "tools/shovel"),
        HOE(NameSpace.FORGE, "tools/hoe"),
        SCYTHE(NameSpace.FORGE, "tools/scythe"),
        IRON_PLATE(NameSpace.FORGE, "plates/iron");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? DesiresTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllFluidTags {
        FAN_PROCESSING_CATALYSTS_SANDING(NameSpace.MOD, "fan_processing_catalysts/sanding"),
        FAN_PROCESSING_CATALYSTS_FREEZING(NameSpace.MOD, "fan_processing_catalysts/freezing"),
        FAN_PROCESSING_CATALYSTS_SEETHING(NameSpace.MOD, "fan_processing_catalysts/seething"),
        INDUSTRIAL_FAN_HEATER,
        SAP(NameSpace.FORGE);

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private AllFluidTags() {
            this(NameSpace.MOD);
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? DesiresTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        private static void init() {
        }
    }

    public static final class DesiresEntityTags
    extends Enum<DesiresEntityTags> {
        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ DesiresEntityTags[] $VALUES;

        public static DesiresEntityTags[] values() {
            return (DesiresEntityTags[])$VALUES.clone();
        }

        public static DesiresEntityTags valueOf(String name) {
            return Enum.valueOf(DesiresEntityTags.class, name);
        }

        private DesiresEntityTags() {
            this(NameSpace.MOD);
        }

        private DesiresEntityTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private DesiresEntityTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private DesiresEntityTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private DesiresEntityTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? DesiresTags.optionalTag(ForgeRegistries.ENTITY_TYPES, id) : TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> type) {
            return type.m_204039_(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.m_6095_());
        }

        private static void init() {
        }

        private static /* synthetic */ DesiresEntityTags[] $values() {
            return new DesiresEntityTags[0];
        }

        static {
            $VALUES = DesiresEntityTags.$values();
        }
    }

    public static final class DesiresRecipeSerializerTags
    extends Enum<DesiresRecipeSerializerTags> {
        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ DesiresRecipeSerializerTags[] $VALUES;

        public static DesiresRecipeSerializerTags[] values() {
            return (DesiresRecipeSerializerTags[])$VALUES.clone();
        }

        public static DesiresRecipeSerializerTags valueOf(String name) {
            return Enum.valueOf(DesiresRecipeSerializerTags.class, name);
        }

        private DesiresRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private DesiresRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private DesiresRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private DesiresRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private DesiresRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? DesiresTags.optionalTag(ForgeRegistries.RECIPE_SERIALIZERS, id) : TagKey.m_203882_((ResourceKey)Registries.f_256764_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            return ((Holder)ForgeRegistries.RECIPE_SERIALIZERS.getHolder(recipeSerializer).orElseThrow()).m_203656_(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ DesiresRecipeSerializerTags[] $values() {
            return new DesiresRecipeSerializerTags[0];
        }

        static {
            $VALUES = DesiresRecipeSerializerTags.$values();
        }
    }

    public static enum NameSpace {
        MOD("create_dd", false, true),
        CREATE("create"),
        FORGE("forge"),
        TIC("tconstruct"),
        QUARK("quark");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

