/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.items.equipment.gilded_rose_tools;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import uwu.lopyluna.create_dd.registry.DesiresTags;

@ParametersAreNonnullByDefault
public class GRPickaxeItem
extends PickaxeItem {
    boolean isOnCooldown;
    boolean offHandPower;

    public GRPickaxeItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pStack) && pEntity instanceof Player) {
            Player pPlayer = (Player)pEntity;
            if (pIsSelected) {
                this.isOnCooldown = pPlayer.m_36335_().m_41519_(pPlayer.m_21205_().m_41720_());
                this.offHandPower = DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pPlayer.m_21206_().m_41720_());
            }
        }
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pStack)) {
            return this.isOnCooldown ? 0.5f : this.f_40980_ * 1.5f;
        }
        return super.m_8102_(pStack, pState);
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return !this.isOnCooldown;
    }

    public float m_41008_() {
        return this.isOnCooldown ? 0.0f : super.m_41008_();
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pStack)) {
            if (pAttacker instanceof Player) {
                Player pPlayer = (Player)pAttacker;
                if (!this.isOnCooldown) {
                    this.resetCooldown(pStack, pPlayer);
                    return true;
                }
            }
            return false;
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pStack)) {
            if (pEntityLiving instanceof Player) {
                Player pPlayer = (Player)pEntityLiving;
                if (!this.isOnCooldown) {
                    this.resetCooldown(pStack, pPlayer);
                    return true;
                }
            }
            return false;
        }
        return super.m_6813_(pStack, pLevel, pState, pPos, pEntityLiving);
    }

    public void resetCooldown(ItemStack pStack, Player pPlayer) {
        if (!pPlayer.m_36335_().m_41519_(pPlayer.m_21205_().m_41720_())) {
            pPlayer.m_36335_().m_41524_((Item)this, this.m_8105_(pStack));
        }
        pStack.m_41622_(2, (LivingEntity)pPlayer, p_43276_ -> p_43276_.m_21166_(EquipmentSlot.MAINHAND));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(stack)) {
            if (enchantment == Enchantments.f_44963_) {
                return true;
            }
            if (enchantment == Enchantments.f_44984_) {
                return true;
            }
            return enchantment == Enchantments.f_44987_;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(itemStack)) {
            return new ItemStack((ItemLike)this.m_41469_());
        }
        return super.getCraftingRemainingItem(itemStack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack pStack, int amount, T entity, Consumer<T> onBroken) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pStack)) {
            int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pStack);
            return super.damageItem(pStack, amount, entity, onBroken) + (fortuneLevel + fortuneLevel) * 5;
        }
        return super.damageItem(pStack, amount, entity, onBroken);
    }

    public float efficiencyDuration(ItemStack pStack) {
        int efficiencyLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)pStack);
        return efficiencyLevel == 0 ? 2.0f : (efficiencyLevel == 1 ? 2.25f : (efficiencyLevel == 2 ? 2.5f : (efficiencyLevel == 3 ? 2.75f : (efficiencyLevel == 4 ? 3.0f : (efficiencyLevel == 5 ? 3.25f : 1.0f)))));
    }

    public int m_8105_(ItemStack pStack) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pStack)) {
            int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pStack);
            if (this.offHandPower) {
                return (int)((float)(fortuneLevel * fortuneLevel * 5) / this.efficiencyDuration(pStack)) + 1;
            }
            return (int)((float)(fortuneLevel * fortuneLevel * 10) / this.efficiencyDuration(pStack)) + 1;
        }
        return super.m_8105_(pStack);
    }

    public boolean m_5812_(ItemStack pStack) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pStack)) {
            return false;
        }
        return super.m_5812_(pStack);
    }

    public boolean m_8120_(ItemStack pStack) {
        if (DesiresTags.AllItemTags.ADDITIONAL_DROPS_TOOL.matches(pStack)) {
            return false;
        }
        return super.m_8120_(pStack);
    }
}

