/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.items.equipment.excavation_drill;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_dd.content.items.equipment.BackTankPickaxeItem;
import uwu.lopyluna.create_dd.content.items.equipment.excavation_drill.ExcavationDrillRenderer;
import uwu.lopyluna.create_dd.infrastructure.utility.BoreMining;
import uwu.lopyluna.create_dd.infrastructure.utility.VeinMining;
import uwu.lopyluna.create_dd.registry.DesireTiers;
import uwu.lopyluna.create_dd.registry.DesiresItems;
import uwu.lopyluna.create_dd.registry.DesiresTags;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExcavationDrillItem
extends BackTankPickaxeItem {
    private static final Set<BlockPos> hashedBlocks = new HashSet<BlockPos>();
    private static boolean veinExcavating = false;

    public ExcavationDrillItem(Item.Properties pProperties) {
        super(DesireTiers.Drill, 1, -2.8f, pProperties);
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return pState.m_204336_(DesiresTags.forgeBlockTag("ores")) ? this.f_40980_ * 0.75f : this.f_40980_;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public static void destroyVein(Level pLevel, BlockState state, BlockPos pos, Player player) {
        boolean playerHeldShift = player.m_6144_();
        if (veinExcavating || !state.m_204336_(DesiresTags.forgeBlockTag("ores")) || !playerHeldShift) {
            return;
        }
        Vec3 vec = player.m_20154_();
        veinExcavating = true;
        VeinMining.findVein((BlockGetter)pLevel, pos).destroyBlocks(pLevel, (LivingEntity)player, (dropPos, item) -> ExcavationDrillItem.dropItemFromExcavatedVein(pLevel, pos, vec, dropPos, item));
        veinExcavating = false;
    }

    public static void dropItemFromExcavatedVein(Level world, BlockPos breakingPos, Vec3 fallDirection, BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.m_123331_((Vec3i)breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(world, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack);
        entity.m_20256_(fallDirection.m_82490_((double)(distance / 16.0f)));
        world.m_7967_((Entity)entity);
    }

    public static boolean validBlocks(BlockState pState, BlockEvent.BreakEvent event, BlockPos blockPos) {
        ItemStack heldItemMainhand = event.getPlayer().m_21120_(InteractionHand.MAIN_HAND);
        return pState.m_60800_((BlockGetter)event.getLevel(), blockPos) != 0.0f || !pState.m_204336_(DesiresTags.forgeBlockTag("ores")) || ((ExcavationDrillItem)((Object)DesiresItems.EXCAVATION_DRILL.get())).isCorrectToolForDrops(heldItemMainhand, pState);
    }

    @SubscribeEvent
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        boolean playerHeldShift = player.m_6144_();
        Level level = (Level)event.getLevel();
        ItemStack heldItemMainhand = event.getPlayer().m_21120_(InteractionHand.MAIN_HAND);
        BlockPos blockPos = event.getPos();
        boolean validOres = event.getLevel().m_8055_(blockPos).m_204336_(DesiresTags.forgeBlockTag("ores"));
        if (DesiresItems.EXCAVATION_DRILL.isIn(heldItemMainhand) && validOres) {
            ExcavationDrillItem.destroyVein((Level)event.getLevel(), event.getState(), event.getPos(), event.getPlayer());
        }
        if (DesiresItems.EXCAVATION_DRILL.isIn(heldItemMainhand) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (playerHeldShift && !validOres) {
                BlockPos initalBlockPos = event.getPos();
                if (hashedBlocks.contains(initalBlockPos)) {
                    return;
                }
                for (BlockPos pos : BoreMining.getBlocksToBeDestroyed(1, initalBlockPos, serverPlayer)) {
                    if (pos == initalBlockPos || event.getLevel().m_8055_(pos).m_60800_((BlockGetter)event.getLevel(), pos) == 0.0f || event.getLevel().m_8055_(pos).m_204336_(DesiresTags.forgeBlockTag("ores")) || !((ExcavationDrillItem)((Object)DesiresItems.EXCAVATION_DRILL.get())).isCorrectToolForDrops(heldItemMainhand, event.getLevel().m_8055_(pos))) continue;
                    hashedBlocks.add(pos);
                    Vec3 vec = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)pos), (RandomSource)level.f_46441_, (float)0.125f);
                    BlockHelper.destroyBlockAs((Level)level, (BlockPos)pos, (Player)player, (ItemStack)heldItemMainhand, (float)1.0f, stack -> {
                        if (stack.m_41619_()) {
                            return;
                        }
                        if (!level.m_46469_().m_46207_(GameRules.f_46136_)) {
                            return;
                        }
                        if (level.restoringBlockSnapshots) {
                            return;
                        }
                        ItemEntity itementity = new ItemEntity(level, vec.f_82479_, vec.f_82480_, vec.f_82481_, stack);
                        itementity.m_32060_();
                        itementity.m_20256_(Vec3.f_82478_);
                        level.m_7967_((Entity)itementity);
                    });
                    hashedBlocks.remove(pos);
                }
            }
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new ExcavationDrillRenderer()));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)ExcavationDrillItem.maxUses());
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)ExcavationDrillItem.maxUses());
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)ExcavationDrillItem.maxUses());
    }

    public static int maxUses() {
        return DesireTiers.Drill.m_6609_();
    }
}

