/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.blocks.kinetics.multimeter;

import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import uwu.lopyluna.create_dd.content.blocks.kinetics.multimeter.GaugeShaper;
import uwu.lopyluna.create_dd.content.blocks.kinetics.multimeter.MultiMeterBlockEntity;
import uwu.lopyluna.create_dd.registry.DesiresBlockEntityTypes;

@ParametersAreNonnullByDefault
public class MultiMeterBlock
extends DirectionalAxisKineticBlock
implements IBE<MultiMeterBlockEntity> {
    public static final GaugeShaper GAUGE = GaugeShaper.make();

    public MultiMeterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        Direction face = context.m_43719_();
        BlockPos placedOnPos = context.m_8083_().m_121945_(context.m_43719_().m_122424_());
        BlockState placedOnState = world.m_8055_(placedOnPos);
        Block block = placedOnState.m_60734_();
        if (block instanceof IRotate && ((IRotate)block).hasShaftTowards((LevelReader)world, placedOnPos, placedOnState, face)) {
            boolean lookPositive;
            BlockState toPlace = this.m_49966_();
            Direction horizontalFacing = context.m_8125_();
            Direction nearestLookingDirection = context.m_7820_();
            boolean bl = lookPositive = nearestLookingDirection.m_122421_() == Direction.AxisDirection.POSITIVE;
            toPlace = face.m_122434_() == Direction.Axis.X ? (BlockState)((BlockState)toPlace.m_61124_((Property)FACING, (Comparable)(lookPositive ? Direction.NORTH : Direction.SOUTH))).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(true)) : (face.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)toPlace.m_61124_((Property)FACING, (Comparable)horizontalFacing.m_122424_())).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(horizontalFacing.m_122434_() == Direction.Axis.X)) : (BlockState)((BlockState)toPlace.m_61124_((Property)FACING, (Comparable)(lookPositive ? Direction.WEST : Direction.EAST))).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(false)));
            return toPlace;
        }
        return super.m_5573_(context);
    }

    protected Direction getFacingForPlacement(BlockPlaceContext context) {
        return context.m_43719_();
    }

    protected boolean getAxisAlignmentForPlacement(BlockPlaceContext context) {
        return context.m_8125_().m_122434_() != Direction.Axis.X;
    }

    public boolean shouldRenderHeadOnFace(Level world, BlockPos pos, BlockState state, Direction face) {
        if (face.m_122434_().m_122478_()) {
            return false;
        }
        if (face == ((Direction)state.m_61143_((Property)FACING)).m_122424_()) {
            return false;
        }
        if (face.m_122434_() == this.getRotationAxis(state)) {
            return false;
        }
        if (this.getRotationAxis(state) == Direction.Axis.Y && face != state.m_61143_((Property)FACING)) {
            return false;
        }
        return Block.m_152444_((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)pos.m_121945_(face)) || world instanceof WrappedWorld;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockEntity be = worldIn.m_7702_(pos);
        if (be == null || !(be instanceof MultiMeterBlockEntity)) {
            return;
        }
        MultiMeterBlockEntity gaugeBE = (MultiMeterBlockEntity)be;
        if (gaugeBE.dialTarget == 0.0f) {
            return;
        }
        int color = gaugeBE.color;
        for (Direction face : Iterate.directions) {
            int particleCount;
            if (!this.shouldRenderHeadOnFace(worldIn, pos, stateIn, face)) continue;
            Vector3f rgb = new Color(color).asVectorF();
            Vec3 faceVec = Vec3.m_82528_((Vec3i)face.m_122436_());
            Direction positiveFacing = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)face.m_122434_());
            Vec3 positiveFaceVec = Vec3.m_82528_((Vec3i)positiveFacing.m_122436_());
            int n = particleCount = gaugeBE.dialTarget > 1.0f ? 4 : 1;
            if (particleCount == 1 && rand.m_188501_() > 0.25f) continue;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 mul = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)rand, (float)0.25f).m_82559_(new Vec3(1.0, 1.0, 1.0).m_82546_(positiveFaceVec)).m_82541_().m_82490_((double)0.3f);
                Vec3 offset = VecHelper.getCenterOf((Vec3i)pos).m_82549_(faceVec.m_82490_(0.55)).m_82549_(mul);
                worldIn.m_7106_((ParticleOptions)new DustParticleOptions(rgb, 1.0f), offset.f_82479_, offset.f_82480_, offset.f_82481_, mul.f_82479_, mul.f_82480_, mul.f_82481_);
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return GAUGE.get((Direction)state.m_61143_((Property)FACING), (Boolean)state.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public Class<MultiMeterBlockEntity> getBlockEntityClass() {
        return MultiMeterBlockEntity.class;
    }

    public BlockEntityType<? extends MultiMeterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DesiresBlockEntityTypes.MULTIMETER.get();
    }
}

