/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.blocks.kinetics.industrial_fan_block;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlock;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import uwu.lopyluna.create_dd.content.blocks.kinetics.industrial_fan_block.IndustrialFanBlock;
import uwu.lopyluna.create_dd.content.blocks.kinetics.industrial_fan_block.extended.IAirCurrentSourceExtended;
import uwu.lopyluna.create_dd.registry.DesiresBlocks;
import uwu.lopyluna.create_dd.registry.DesiresTags;

public class IndustrialFanBlockEntity
extends GeneratingKineticBlockEntity
implements IAirCurrentSourceExtended {
    protected boolean isGenerator = false;
    protected boolean updateGenerator = false;
    public AirCurrent airCurrent = new AirCurrent((IAirCurrentSource)this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow = true;

    public IndustrialFanBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.ENCASED_FAN, AllAdvancements.FAN_PROCESSING});
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (!this.wasMoved) {
            this.isGenerator = compound.m_128471_("Generating");
        }
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Generating", this.isGenerator);
        super.write(compound, clientPacket);
    }

    public float calculateAddedStressCapacity() {
        return this.isGenerator ? super.calculateAddedStressCapacity() : 0.0f;
    }

    public float calculateStressApplied() {
        return this.isGenerator ? 0.0f : super.calculateStressApplied();
    }

    public float getGeneratedSpeed() {
        return this.isGenerator ? 64.0f : 0.0f;
    }

    public void queueGeneratorUpdate() {
        this.updateGenerator = true;
    }

    public void updateGenerator() {
        BlockState blockState = this.m_58900_();
        boolean shouldGenerate = DesiresBlocks.INDUSTRIAL_FAN.has(blockState);
        if (shouldGenerate && blockState.m_61143_((Property)IndustrialFanBlock.FACING) != Direction.DOWN && !this.blockBelowIsHot()) {
            shouldGenerate = false;
        }
        if (shouldGenerate) {
            boolean bl = shouldGenerate = this.f_58857_ != null && this.blockBelowIsHot() && (this.f_58857_.m_276987_(this.f_58858_, Direction.DOWN) || this.f_58857_.m_276867_(this.f_58858_.m_7495_())) && blockState.m_61143_((Property)IndustrialFanBlock.FACING) == Direction.DOWN;
        }
        if (shouldGenerate == this.isGenerator) {
            return;
        }
        this.isGenerator = shouldGenerate;
        this.updateGeneratedRotation();
    }

    public boolean blockBelowIsHot() {
        FluidState fluidState = this.f_58857_.m_6425_(this.f_58858_.m_7495_());
        if (DesiresTags.AllFluidTags.INDUSTRIAL_FAN_HEATER.matches(fluidState)) {
            return true;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        if (DesiresTags.AllBlockTags.INDUSTRIAL_FAN_HEATER.matches(blockState)) {
            return !blockState.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        }
        return false;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return this.f_58857_;
    }

    public BlockPos getAirCurrentPos() {
        return this.f_58858_;
    }

    public Direction getAirflowOriginSide() {
        return (Direction)this.m_58900_().m_61143_((Property)EncasedFanBlock.FACING);
    }

    @Nullable
    public Direction getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        return (speed = IndustrialFanBlockEntity.convertToDirection((float)speed, (Direction)facing)) > 0.0f ? facing : facing.m_122424_();
    }

    public void remove() {
        super.remove();
        this.updateChute();
    }

    public boolean isSourceRemoved() {
        return this.f_58859_;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void updateChute() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)EncasedFanBlock.FACING);
        if (!direction.m_122434_().m_122478_()) {
            return;
        }
        BlockEntity poweredChute = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (!(poweredChute instanceof ChuteBlockEntity)) {
            return;
        }
        ChuteBlockEntity chuteBE = (ChuteBlockEntity)poweredChute;
        if (direction == Direction.DOWN) {
            chuteBE.updatePull();
        } else {
            chuteBE.updatePush(1);
        }
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    public void tick() {
        boolean server;
        super.tick();
        boolean bl = server = !this.f_58857_.f_46443_ || this.isVirtual();
        if (server && this.airCurrentUpdateCooldown-- <= 0) {
            this.airCurrentUpdateCooldown = (Integer)AllConfigs.server().kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            if (this.airCurrent.maxDistance > 0.0f) {
                this.award(AllAdvancements.ENCASED_FAN);
            }
            this.sendData();
        }
        if (this.updateGenerator) {
            this.updateGenerator = false;
            this.updateGenerator();
        }
        if (this.isGenerator || this.getSpeed() == 0.0f) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        this.airCurrent.tick();
    }
}

