/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PrivateAnimatedResultButton
extends AbstractWidget {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("textures/gui/recipe_book.png");
    private AbstractPrivateRecipeScreenHandler craftingScreenHandler;
    private Recipe<?> recipe;
    private float bounce;

    public PrivateAnimatedResultButton() {
        super(0, 0, 25, 25, CommonComponents.f_237098_);
    }

    public void showResultCollection(Recipe<?> recipe, AbstractPrivateRecipeScreenHandler craftingScreenHandler) {
        this.recipe = recipe;
        this.craftingScreenHandler = craftingScreenHandler;
    }

    public Recipe<?> getRecipe() {
        return this.recipe;
    }

    public void setPos(int x, int y) {
        this.m_252865_(x);
        this.m_253211_(y);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        int i = 29;
        if (!this.craftingScreenHandler.hasIngredient(this.recipe)) {
            i += 25;
        }
        int j = 206;
        boolean bl = this.bounce > 0.0f;
        PoseStack poseStack = RenderSystem.getModelViewStack();
        if (bl) {
            float f = 1.0f + 0.1f * (float)Math.sin(this.bounce / 15.0f * (float)Math.PI);
            poseStack.m_85836_();
            poseStack.m_85837_((double)(this.m_252754_() + 8), (double)(this.m_252907_() + 12), 0.0);
            poseStack.m_85841_(f, f, 1.0f);
            poseStack.m_85837_((double)(-(this.m_252754_() + 8)), (double)(-(this.m_252907_() + 12)), 0.0);
            RenderSystem.applyModelViewMatrix();
            this.bounce -= delta;
        }
        guiGraphics.m_280218_(BACKGROUND_TEXTURE, this.m_252754_(), this.m_252907_(), i, j, this.f_93618_, this.f_93619_);
        Recipe<?> recipe = this.getResult();
        int k = 4;
        guiGraphics.m_280480_(recipe.m_8043_(minecraftClient.f_91073_.m_9598_()), this.m_252754_() + k, this.m_252907_() + k);
        if (bl) {
            poseStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private Recipe<?> getResult() {
        return this.recipe;
    }

    public boolean hasResult() {
        return this.getResult() != null;
    }

    public Recipe<?> currentRecipe() {
        return this.getResult();
    }

    protected boolean m_7972_(int button) {
        return button == 0 || button == 1;
    }

    public List<Component> getOutputTooltip() {
        ItemStack itemStack = this.getResult().m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
        return List.of(itemStack.m_41786_());
    }

    protected void m_168797_(NarrationElementOutput builder) {
        ItemStack itemStack = this.getResult().m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
        builder.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.recipe", (Object[])new Object[]{itemStack.m_41786_()}));
        builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.button.usage.hovered"));
    }

    public int m_5711_() {
        return 25;
    }
}

