/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.inventory.slots;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.inventory.slots.TooltippedSlotDescription;
import immersive_aircraft.screen.slot.IngredientSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientSlotDescription
extends TooltippedSlotDescription {
    final Ingredient ingredient;
    final int maxStackSize;

    public IngredientSlotDescription(String type, int index, int x, int y, JsonObject json) {
        this(type, index, x, y, json, Ingredient.m_43917_((JsonElement)json.get("ingredient")), GsonHelper.m_13824_((JsonObject)json, (String)"maxStackSize", (int)64));
    }

    public IngredientSlotDescription(String type, int index, int x, int y, JsonObject json, Ingredient ingredient, int maxStackSize) {
        super(type, index, x, y, json);
        this.ingredient = ingredient;
        this.maxStackSize = maxStackSize;
    }

    public IngredientSlotDescription(String type, FriendlyByteBuf buffer) {
        super(type, buffer);
        this.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        this.maxStackSize = buffer.readInt();
    }

    @Override
    public Slot getSlot(InventoryVehicleEntity vehicle, Container inventory) {
        return new IngredientSlot(this.ingredient, this.maxStackSize, inventory, this.index, this.x, this.y);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        this.ingredient.m_43923_(buffer);
        buffer.writeInt(this.maxStackSize);
    }
}

