/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.HugeLilyPadBlock;
import biomesoplenty.block.properties.QuarterProperty;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;

public class HugeLilyPadFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> (world.m_8055_(pos).m_60819_().m_76152_() == Fluids.f_76193_ || world.m_8055_(pos).m_60734_() instanceof IceBlock) && world.m_8055_(pos.m_7494_()).m_60819_().m_76152_() == Fluids.f_76191_;
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60734_() == BOPBlocks.WATERGRASS;

    public HugeLilyPadFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos startPos = featurePlaceContext.m_159777_();
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        while (startPos.m_123342_() >= world.m_141937_() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.m_7495_();
        }
        if (!this.placeOn.matches(world, startPos)) {
            return false;
        }
        if (!this.checkSpace(world, startPos.m_7494_(), direction)) {
            return false;
        }
        BlockPos pos = startPos.m_7494_();
        this.setBlock(world, pos, (BlockState)((BlockState)BOPBlocks.HUGE_LILY_PAD.m_49966_().m_61124_(HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.SOUTH_WEST))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction));
        this.setBlock(world, pos.m_121945_(direction), (BlockState)((BlockState)BOPBlocks.HUGE_LILY_PAD.m_49966_().m_61124_(HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.NORTH_WEST))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction));
        this.setBlock(world, pos.m_121945_(direction).m_121945_(direction.m_122427_()), (BlockState)((BlockState)BOPBlocks.HUGE_LILY_PAD.m_49966_().m_61124_(HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.NORTH_EAST))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction));
        this.setBlock(world, pos.m_121945_(direction.m_122427_()), (BlockState)((BlockState)BOPBlocks.HUGE_LILY_PAD.m_49966_().m_61124_(HugeLilyPadBlock.QUARTER, (Comparable)((Object)QuarterProperty.SOUTH_EAST))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction));
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            super.m_159739_(world, pos.m_7495_());
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, Direction direction) {
        BlockPos pos1 = pos;
        BlockPos pos2 = pos.m_121945_(direction);
        BlockPos pos3 = pos2.m_121945_(direction.m_122427_());
        BlockPos pos4 = pos.m_121945_(direction.m_122427_());
        return pos1.m_123342_() < 255 && this.replace.matches(world, pos1) && this.placeOn.matches(world, pos1.m_7495_()) && pos2.m_123342_() < 255 && this.replace.matches(world, pos2) && this.placeOn.matches(world, pos2.m_7495_()) && pos3.m_123342_() < 255 && this.replace.matches(world, pos3) && this.placeOn.matches(world, pos3.m_7495_()) && pos4.m_123342_() < 255 && this.replace.matches(world, pos4) && this.placeOn.matches(world, pos4.m_7495_());
    }
}

