/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import satisfy.beachparty.registry.ArmorMaterialRegistry;

public interface IBeachpartyArmorSet {
    public static final Map<ArmorMaterial, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ArmorMaterialRegistry.BIKINI, (Object)new MobEffectInstance(MobEffects.f_19593_, 280, 1)).put((Object)ArmorMaterialRegistry.TRUNKS, (Object)new MobEffectInstance(MobEffects.f_19593_, 280, 1)).put((Object)ArmorMaterialRegistry.SWIM_WINGS, (Object)new MobEffectInstance(MobEffects.f_19593_, 280, 0)).put((Object)ArmorMaterialRegistry.RING, (Object)new MobEffectInstance(MobEffects.f_19593_, 280, 1)).build();

    default public boolean hasSwimwearSet(Player player) {
        return IBeachpartyArmorSet.hasSwimearBoots(player) && IBeachpartyArmorSet.hasSwimearLeggings(player) && IBeachpartyArmorSet.hasSwimwearBreastplate(player) && IBeachpartyArmorSet.hasSwimearHelmet(player);
    }

    default public void checkForSet(Player player) {
        if (this.hasSwimwearSet(player)) {
            this.addStatusEffectForMaterial(player, new MobEffectInstance(MobEffects.f_19593_, 280, 2));
            this.addStatusEffectForMaterial(player, new MobEffectInstance(MobEffects.f_19608_, 280, 0));
        }
        this.hasSwimwear(player);
    }

    default public void hasSwimwear(Player player) {
        for (Map.Entry<ArmorMaterial, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorMaterial mapArmorMaterial = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            if (!this.hasCorrectSwimWear(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapStatusEffect);
        }
    }

    private boolean hasCorrectSwimWear(ArmorMaterial material, Player player) {
        if (material.equals((Object)ArmorMaterialRegistry.BIKINI) || material.equals((Object)ArmorMaterialRegistry.TRUNKS)) {
            int slot = 1;
            if (!player.m_150109_().m_36052_(slot).m_41619_()) {
                ArmorItem armor = (ArmorItem)player.m_150109_().m_36052_(slot).m_41720_();
                return armor.m_40401_() == material;
            }
            return false;
        }
        if (material.equals((Object)ArmorMaterialRegistry.SWIM_WINGS) || material.equals((Object)ArmorMaterialRegistry.RING)) {
            Item item;
            int slot = 2;
            if (!player.m_150109_().m_36052_(slot).m_41619_() && (item = player.m_150109_().m_36052_(slot).m_41720_()) instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                return armor.m_40401_() == material;
            }
            return false;
        }
        return false;
    }

    default public void addStatusEffectForMaterial(Player player, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        if (!hasPlayerEffect || Objects.requireNonNull(player.m_21124_(mapStatusEffect.m_19544_())).m_19557_() < 220) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect.m_19544_(), mapStatusEffect.m_19557_(), mapStatusEffect.m_19564_(), true, false, true));
        }
    }

    public static boolean hasSwimearBoots(Player player) {
        if (player.m_150109_().m_36052_(0).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(0).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return IBeachpartyArmorSet.isSwimwearBoots(armorItem);
        }
        return false;
    }

    private static boolean isSwimwearBoots(ArmorItem armorItem) {
        return armorItem.m_40401_() == ArmorMaterialRegistry.CROCS;
    }

    public static boolean hasSwimearLeggings(Player player) {
        if (player.m_150109_().m_36052_(1).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(1).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return IBeachpartyArmorSet.isSwimwearLeggings(armorItem);
        }
        return false;
    }

    private static boolean isSwimwearLeggings(ArmorItem armorItem) {
        return armorItem.m_40401_() == ArmorMaterialRegistry.TRUNKS || armorItem.m_40401_() == ArmorMaterialRegistry.BIKINI;
    }

    public static boolean hasSwimwearBreastplate(Player player) {
        if (player.m_150109_().m_36052_(2).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(2).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return IBeachpartyArmorSet.isSwimwearBreastplate(armorItem);
        }
        return false;
    }

    private static boolean isSwimwearBreastplate(ArmorItem armorItem) {
        return armorItem.m_40401_() == ArmorMaterialRegistry.RING || armorItem.m_40401_() == ArmorMaterialRegistry.SWIM_WINGS;
    }

    public static boolean hasSwimearHelmet(Player player) {
        if (player.m_150109_().m_36052_(3).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(3).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return IBeachpartyArmorSet.isSwimwearHelmet(armorItem);
        }
        return false;
    }

    private static boolean isSwimwearHelmet(ArmorItem armorItem) {
        return armorItem.m_40401_() == ArmorMaterialRegistry.BEACH_HAT || armorItem.m_40401_() == ArmorMaterialRegistry.SUNGLASSES;
    }
}

