/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import satisfy.beachparty.recipe.TikiBarRecipe;
import satisfy.beachparty.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public enum TikiBarRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    COCKTAIL(new ItemStack((ItemLike)ObjectRegistry.COCONUT_COCKTAIL.get())),
    MISC(new ItemStack((ItemLike)ObjectRegistry.COCONUT.get()));

    public static final List<IRecipeBookGroup> TIKI_GROUPS;
    private final List<ItemStack> icons;

    private TikiBarRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<?> recipe, RegistryAccess registryAccess) {
        if (recipe instanceof TikiBarRecipe) {
            TikiBarRecipe tikiBarRecipe = (TikiBarRecipe)recipe;
            switch (this) {
                case SEARCH: {
                    return true;
                }
                case COCKTAIL: {
                    if (!tikiBarRecipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(Blocks.f_50126_.m_5456_().m_7968_()))) break;
                    return true;
                }
                case MISC: {
                    if (!tikiBarRecipe.m_7527_().stream().noneMatch(ingredient -> ingredient.test(Blocks.f_50126_.m_5456_().m_7968_()))) break;
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        TIKI_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)COCKTAIL), (Object)((Object)MISC));
    }
}

