/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.block;

import de.cristelknight.doapi.common.util.GeneralUtil;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import satisfy.beachparty.networking.BeachpartyMessages;
import satisfy.beachparty.registry.SoundEventRegistry;

public class RadioBlock
extends Block {
    public static final BooleanProperty ON;
    public static final IntegerProperty CHANNEL;
    public static final DirectionProperty FACING;
    public static final BooleanProperty SEARCHING;
    public static final int CHANNELS;
    public static final int DELAY = 40;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    public static final Map<Direction, VoxelShape> SHAPE;

    public RadioBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CHANNEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        int channel = RandomSource.m_216327_().m_216332_(0, CHANNELS - 1);
        Direction facing = Direction.NORTH;
        if (context.m_8125_().m_122434_() != Direction.Axis.Y) {
            facing = context.m_8125_().m_122424_();
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)CHANNEL, (Comparable)Integer.valueOf(channel));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)SEARCHING)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            boolean newState;
            boolean bl = newState = (Boolean)state.m_61143_((Property)ON) == false;
            if (newState) {
                this.turnON(state, world, pos, player);
                RadioBlock.spawnParticles(world, pos);
            } else {
                this.turnOFF(state, world, pos, player);
            }
            if (!world.f_46443_) {
                if (newState) {
                    for (int i = 0; i < 5; ++i) {
                        double x = (double)pos.m_123341_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5;
                        double y = (double)pos.m_123342_() + 0.5 + world.f_46441_.m_188500_() * 0.5;
                        double z = (double)pos.m_123343_() + 0.5 + (world.f_46441_.m_188500_() - 0.5) * 0.5;
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x, y, z, 0.0, 0.0, 0.0);
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x, y, z, 0.1, 0.0, 0.0);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    private void turnON(BlockState state, Level world, BlockPos pos, Player player) {
        world.m_5594_(player, pos, (SoundEvent)SoundEventRegistry.RADIO_CLICK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_5594_(player, pos, (SoundEvent)SoundEventRegistry.RADIO_TUNE.get(), SoundSource.RECORDS, 0.8f, 1.0f);
        if (!world.f_46443_) {
            this.pressButton(state, world, pos, true);
            this.sendPacket(state, (ServerLevel)world, pos, true);
        }
    }

    private void turnOFF(BlockState state, Level world, BlockPos pos, Player player) {
        world.m_5594_(player, pos, (SoundEvent)SoundEventRegistry.RADIO_CLICK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!world.f_46443_) {
            this.pressButton(state, world, pos, false);
            this.sendPacket(state, (ServerLevel)world, pos, false);
        }
    }

    public int tune(Level world, BlockState blockState, BlockPos blockPos, int scrollValue) {
        if (scrollValue % CHANNELS == 0) {
            return (Integer)blockState.m_61143_((Property)CHANNEL);
        }
        int currentChannel = (Integer)blockState.m_61143_((Property)CHANNEL);
        int newChannel = scrollValue < 0 ? (CHANNELS - Math.abs(currentChannel + scrollValue) % CHANNELS) % CHANNELS : (currentChannel + scrollValue) % CHANNELS;
        world.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)CHANNEL, (Comparable)Integer.valueOf(newChannel))).m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(true)), 3);
        world.m_186460_(blockPos, (Block)this, 40);
        return newChannel;
    }

    private void pressButton(BlockState state, Level world, BlockPos pos, boolean on) {
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf(on))).m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(true)), 3);
        world.m_186460_(pos, (Block)this, 40);
    }

    private void sendPacket(BlockState state, ServerLevel world, BlockPos pos, boolean on) {
        for (ServerPlayer player : world.m_6907_()) {
            FriendlyByteBuf buffer = RadioBlock.createPacketBuf();
            buffer.m_130064_(pos);
            buffer.writeInt(((Integer)state.m_61143_((Property)CHANNEL)).intValue());
            buffer.writeBoolean(on);
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)BeachpartyMessages.TURN_RADIO_S2C, (FriendlyByteBuf)buffer);
        }
    }

    public static FriendlyByteBuf createPacketBuf() {
        return new FriendlyByteBuf(Unpooled.buffer());
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (!world.f_46443_) {
                this.sendPacket(state, (ServerLevel)world, pos, false);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)SEARCHING)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)SEARCHING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)ON)).booleanValue()) {
            RadioBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(Level world, BlockPos pos) {
        RandomSource random = world.f_46441_;
        double d = (double)pos.m_123341_() + random.m_188500_();
        double e = (double)pos.m_123342_() + 0.5 + random.m_188500_();
        double f = (double)pos.m_123343_() + random.m_188500_();
        world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, d, e, f, 0.0, 0.0, 0.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ON, CHANNEL, SEARCHING});
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.beachparty.canbeplaced").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    static {
        FACING = HorizontalDirectionalBlock.f_54117_;
        CHANNELS = SoundEventRegistry.RADIO_SOUNDS.size();
        voxelShapeSupplier = () -> Shapes.m_83048_((double)0.125, (double)0.0, (double)0.3125, (double)0.875, (double)0.5, (double)0.6875);
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
        ON = BooleanProperty.m_61465_((String)"on");
        CHANNEL = IntegerProperty.m_61631_((String)"channel", (int)0, (int)(CHANNELS - 1));
        SEARCHING = BooleanProperty.m_61465_((String)"searching");
    }
}

