/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AbstractPresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.AlternativeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SpitItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.TrappedPresentBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrappedPresentBlock
extends AbstractPresentBlock
implements ILightable {
    private static final Map<Item, IFireItemBehavior> FIRE_BEHAVIORS = new IdentityHashMap<Item, IFireItemBehavior>();
    private static final IFireItemBehavior DEFAULT = new AlternativeBehavior(new GenericProjectileBehavior(), new SpitItemBehavior());
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ON_COOLDOWN = BlockStateProperties.f_61360_;

    public TrappedPresentBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
    }

    public static void registerBehavior(ItemLike pItem, IFireItemBehavior pBehavior) {
        FIRE_BEHAVIORS.put(pItem.m_5456_(), pBehavior);
    }

    public static IFireItemBehavior getPresentBehavior(ItemLike item) {
        return FIRE_BEHAVIORS.getOrDefault(item, DEFAULT);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, ON_COOLDOWN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TrappedPresentBlockTile(pPos, pState);
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        if (pId == 0 && ((Boolean)pState.m_61143_((Property)ON_COOLDOWN)).booleanValue()) {
            if (pLevel.f_46443_) {
                RandomSource random = pLevel.f_46441_;
                double cx = (double)pPos.m_123341_() + 0.5;
                double cy = (double)pPos.m_123342_() + 0.5 + 0.4;
                double cz = (double)pPos.m_123343_() + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double speed = random.m_188500_() * 0.15 + 0.015;
                    double py = cy + 0.02 + (random.m_188500_() - 0.5) * 0.3;
                    double dx = random.m_188583_() * 0.01;
                    double dy = speed + random.m_188583_() * 0.01;
                    double dz = random.m_188583_() * 0.01;
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123796_, cx, py, cz, dx, dy, dz);
                }
                ParticleUtil.spawnBreakParticles((VoxelShape)PresentBlock.SHAPE_LID, (BlockPos)pPos, (BlockState)pState, (Level)pLevel);
            }
            return true;
        }
        return super.m_8133_(pState, pLevel, pPos, pId, pParam);
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        if (((Boolean)state.m_61143_((Property)ON_COOLDOWN)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        boolean isPowered = world.m_276867_(pos);
        if (isPowered) {
            this.lightUp(null, state, pos, (LevelAccessor)world, ILightable.FireSourceType.FIRE_CHANGE);
        }
    }

    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)PACKED) == false;
    }

    public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSourceType fireSourceType) {
        BlockEntity blockEntity;
        if (this.isLitUp(state, (BlockGetter)world, pos) && (blockEntity = world.m_7702_(pos)) instanceof TrappedPresentBlockTile) {
            TrappedPresentBlockTile tile = (TrappedPresentBlockTile)blockEntity;
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                tile.detonate((LevelAccessor)serverLevel, pos, state, null);
            }
            return true;
        }
        return false;
    }
}

