/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import com.mojang.datafixers.util.Pair;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotDiscreteCoinBag
extends Slot {
    private static final Container emptyInventory = new SimpleContainer(0);
    private final DiscreteCoinBag coinBag;
    private final Coin coin;
    private final boolean canInsert;
    private final boolean canExtract;

    public SlotDiscreteCoinBag(DiscreteCoinBag coinBag, Coin coin, int x, int y, boolean canInsert, boolean canExtract) {
        super(emptyInventory, 0, x, y);
        this.coinBag = coinBag;
        this.coin = coin;
        this.canInsert = canInsert;
        this.canExtract = canExtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_5857_(ItemStack stack) {
        if (!this.canInsert) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof CoinItem)) return false;
        CoinItem coinItem = (CoinItem)item;
        if (coinItem.coin != this.coin) return false;
        return true;
    }

    @NotNull
    public ItemStack m_7993_() {
        return this.coinBag.asStack(this.coin);
    }

    public void m_5852_(ItemStack stack) {
        block3: {
            block2: {
                if (stack.m_41619_()) break block2;
                Item item = stack.m_41720_();
                if (!(item instanceof CoinItem)) break block3;
                CoinItem coinItem = (CoinItem)item;
                if (coinItem.coin != this.coin) break block3;
            }
            this.coinBag.setDiscrete(this.coin, stack.m_41613_());
            this.m_6654_();
        }
    }

    public void m_40234_(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
    }

    public int m_6641_() {
        return Integer.MAX_VALUE;
    }

    public int m_5866_(ItemStack stack) {
        return this.m_6641_();
    }

    public boolean m_8010_(@NotNull Player player) {
        if (!this.canExtract) {
            return false;
        }
        return this.coinBag.getDiscrete(this.coin) > 0;
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        if ((amount = Math.min(amount, this.coinBag.getDiscrete(this.coin))) <= 0) {
            return ItemStack.f_41583_;
        }
        this.coinBag.subtract(this.coin, amount);
        return this.coin.asStack(amount);
    }

    public boolean tryPlace(ItemStack stack) {
        if (!this.m_5857_(stack)) {
            return false;
        }
        this.coinBag.add(this.coin, stack.m_41613_());
        stack.m_41764_(0);
        this.m_6654_();
        return true;
    }

    @NotNull
    public Optional<ItemStack> m_150641_(int count, int decrement, @NotNull Player player) {
        return super.m_150641_(count, Math.min(64, decrement), player);
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        return Pair.of((Object)InventoryMenu.f_39692_, (Object)Numismatics.asResource("item/coin/outline/" + this.coin.getName()));
    }
}

