/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.gson.JsonObject;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.infrastructure.ponder.PonderIndex;
import com.tterrag.registrate.AbstractRegistrate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;

public class PonderLocalization {
    static final Map<ResourceLocation, String> SHARED = new HashMap<ResourceLocation, String>();
    static final Map<ResourceLocation, Couple<String>> TAG = new HashMap<ResourceLocation, Couple<String>>();
    static final Map<ResourceLocation, String> CHAPTER = new HashMap<ResourceLocation, String>();
    static final Map<ResourceLocation, Map<String, String>> SPECIFIC = new HashMap<ResourceLocation, Map<String, String>>();
    public static final String LANG_PREFIX = "ponder.";
    private static boolean sceneLangGenerated = false;

    public static void registerShared(ResourceLocation key, String enUS) {
        SHARED.put(key, enUS);
    }

    public static void registerTag(ResourceLocation key, String enUS, String description) {
        TAG.put(key, Couple.create(enUS, description));
    }

    public static void registerChapter(ResourceLocation key, String enUS) {
        CHAPTER.put(key, enUS);
    }

    public static void registerSpecific(ResourceLocation sceneId, String key, String enUS) {
        SPECIFIC.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    protected static String langKeyForShared(ResourceLocation k) {
        return k.m_135827_() + ".ponder.shared." + k.m_135815_();
    }

    protected static String langKeyForTag(ResourceLocation k) {
        return k.m_135827_() + ".ponder.tag." + k.m_135815_();
    }

    protected static String langKeyForTagDescription(ResourceLocation k) {
        return k.m_135827_() + ".ponder.tag." + k.m_135815_() + ".description";
    }

    protected static String langKeyForChapter(ResourceLocation k) {
        return k.m_135827_() + ".ponder.chapter." + k.m_135815_();
    }

    protected static String langKeyForSpecific(ResourceLocation sceneId, String k) {
        return sceneId.m_135827_() + ".ponder." + sceneId.m_135815_() + "." + k;
    }

    public static String getShared(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return SHARED.containsKey(key) ? SHARED.get(key) : "unregistered shared entry: " + key;
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForShared(key), (Object[])new Object[0]);
    }

    public static String getTag(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return TAG.containsKey(key) ? (String)TAG.get(key).getFirst() : "unregistered tag entry: " + key;
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForTag(key), (Object[])new Object[0]);
    }

    public static String getTagDescription(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return TAG.containsKey(key) ? (String)TAG.get(key).getSecond() : "unregistered tag entry: " + key;
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForTagDescription(key), (Object[])new Object[0]);
    }

    public static String getChapter(ResourceLocation key) {
        if (PonderIndex.editingModeActive()) {
            return CHAPTER.containsKey(key) ? CHAPTER.get(key) : "unregistered chapter entry: " + key;
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForChapter(key), (Object[])new Object[0]);
    }

    public static String getSpecific(ResourceLocation sceneId, String k) {
        if (PonderIndex.editingModeActive()) {
            return SPECIFIC.get(sceneId).get(k);
        }
        return I18n.m_118938_((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])new Object[0]);
    }

    public static void generateSceneLang() {
        if (sceneLangGenerated) {
            return;
        }
        sceneLangGenerated = true;
        PonderRegistry.ALL.forEach((id, list) -> {
            for (int i = 0; i < list.size(); ++i) {
                PonderRegistry.compileScene(i, (PonderStoryBoardEntry)list.get(i), null);
            }
        });
    }

    public static void provideLang(String namespace, BiConsumer<String, String> consumer) {
        SHARED.forEach((k, v) -> {
            if (k.m_135827_().equals(namespace)) {
                consumer.accept(PonderLocalization.langKeyForShared(k), (String)v);
            }
        });
        TAG.forEach((k, v) -> {
            if (k.m_135827_().equals(namespace)) {
                consumer.accept(PonderLocalization.langKeyForTag(k), (String)v.getFirst());
                consumer.accept(PonderLocalization.langKeyForTagDescription(k), (String)v.getSecond());
            }
        });
        CHAPTER.forEach((k, v) -> {
            if (k.m_135827_().equals(namespace)) {
                consumer.accept(PonderLocalization.langKeyForChapter(k), (String)v);
            }
        });
        SPECIFIC.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).m_135827_().equals(namespace)).sorted(Map.Entry.comparingByKey()).forEach(entry -> ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(subEntry -> consumer.accept(PonderLocalization.langKeyForSpecific((ResourceLocation)entry.getKey(), (String)subEntry.getKey()), (String)subEntry.getValue())));
    }

    @Deprecated(forRemoval=true)
    public static void record(String namespace, JsonObject object) {
        PonderLocalization.provideLang(namespace, (arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
    }

    public static void provideRegistrateLang(AbstractRegistrate<?> registrate) {
        PonderLocalization.generateSceneLang();
        PonderLocalization.provideLang(registrate.getModid(), (arg_0, arg_1) -> registrate.addRawLang(arg_0, arg_1));
    }
}

