/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.hat;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfo;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfoReloadListener;
import com.simibubi.create.foundation.mixin.accessor.AgeableListModelAccessor;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.utility.Couple;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TrainHatArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public TrainHatArmorLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.shouldRenderOn(entity)) {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        RenderType renderType = Sheets.m_110790_();
        ms.m_85836_();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        TrainHatInfo info = TrainHatInfoReloadListener.getHatInfoFor(entity.m_6095_());
        ArrayList<ModelPart> partsToHead = new ArrayList<ModelPart>();
        if (entityModel instanceof AgeableListModel) {
            ModelPart head;
            AgeableListModel model = (AgeableListModel)entityModel;
            if (model.f_102610_) {
                if (model.f_102007_) {
                    float f = 1.5f / model.f_102010_;
                    ms.m_85841_(f, f, f);
                }
                ms.m_85837_(0.0, (double)(model.f_170338_ / 16.0f), (double)(model.f_170339_ / 16.0f));
            }
            if ((head = TrainHatArmorLayer.getHeadPart(model)) != null) {
                partsToHead.addAll(TrainHatInfo.getAdjustedPart(info, head, ""));
            }
        } else if (entityModel instanceof HierarchicalModel) {
            HierarchicalModel model = (HierarchicalModel)entityModel;
            partsToHead.addAll(TrainHatInfo.getAdjustedPart(info, model.m_142109_(), "head"));
        }
        if (!partsToHead.isEmpty()) {
            partsToHead.forEach(part -> part.m_104299_(ms));
            ModelPart lastChild = (ModelPart)partsToHead.get(partsToHead.size() - 1);
            if (!lastChild.m_171326_()) {
                ModelPart.Cube cube = (ModelPart.Cube)lastChild.f_104212_.get(Mth.m_14045_((int)info.cubeIndex(), (int)0, (int)(lastChild.f_104212_.size() - 1)));
                ms.m_85837_(info.offset().m_7096_() / 16.0, ((double)(cube.f_104336_ - cube.f_104339_) + info.offset().m_7098_()) / 16.0, info.offset().m_7094_() / 16.0);
                float max = Math.max(cube.f_104338_ - cube.f_104335_, cube.f_104340_ - cube.f_104337_) / 8.0f * info.scale();
                ms.m_85841_(max, max, max);
            }
            ms.m_85841_(1.0f, -1.0f, -1.0f);
            ms.m_252880_(0.0f, -0.140625f, 0.0f);
            msr.rotateX(-8.5);
            BlockState air = Blocks.f_50016_.m_49966_();
            CachedBufferer.partial(AllPartialModels.TRAIN_HAT, air).forEntityRender().light(light).renderInto(ms, buffer.m_6299_(renderType));
        }
        ms.m_85849_();
    }

    private boolean shouldRenderOn(LivingEntity entity) {
        Player p;
        ItemStack headItem;
        if (entity == null) {
            return false;
        }
        if (entity.getPersistentData().m_128441_("TrainHat")) {
            return true;
        }
        if (!entity.m_20159_()) {
            return false;
        }
        if (entity instanceof Player && !(headItem = (p = (Player)entity).m_6844_(EquipmentSlot.HEAD)).m_41619_()) {
            return false;
        }
        Entity vehicle = entity.m_20202_();
        if (!(vehicle instanceof CarriageContraptionEntity)) {
            return false;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)vehicle;
        if (!cce.hasSchedule() && !(entity instanceof Player)) {
            return false;
        }
        Contraption contraption = cce.getContraption();
        if (!(contraption instanceof CarriageContraption)) {
            return false;
        }
        CarriageContraption cc = (CarriageContraption)contraption;
        BlockPos seatOf = cc.getSeatOf(entity.m_20148_());
        if (seatOf == null) {
            return false;
        }
        Couple<Boolean> validSides = cc.conductorSeats.get(seatOf);
        return validSides != null;
    }

    public static void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            TrainHatArmorLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.f_114362_.values()) {
            TrainHatArmorLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        EntityModel model = livingRenderer.m_7200_();
        if (!(model instanceof HierarchicalModel) && !(model instanceof AgeableListModel)) {
            return;
        }
        livingRenderer.m_115326_(new TrainHatArmorLayer(livingRenderer));
    }

    private static ModelPart getHeadPart(AgeableListModel<?> model) {
        Iterator<ModelPart> iterator = ((AgeableListModelAccessor)model).create$callHeadParts().iterator();
        if (iterator.hasNext()) {
            ModelPart part = iterator.next();
            return part;
        }
        iterator = ((AgeableListModelAccessor)model).create$callBodyParts().iterator();
        if (iterator.hasNext()) {
            ModelPart part = iterator.next();
            return part;
        }
        return null;
    }
}

