/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PhotographRenderProperties {
    public static final ResourceLocation EMPTY_TEXTURE = Exposure.resource("textures/empty.png");
    public static final PhotographRenderProperties DEFAULT = new PhotographRenderProperties("default", stack -> stack.m_41720_() instanceof PhotographItem, Exposure.resource("textures/photograph/photograph.png"), EMPTY_TEXTURE, Exposure.resource("textures/photograph/photograph_album.png"), EMPTY_TEXTURE, ExposurePixelModifiers.EMPTY);
    public static final PhotographRenderProperties AGED = new PhotographRenderProperties("aged", stack -> stack.m_150930_((Item)Exposure.Items.AGED_PHOTOGRAPH.get()), Exposure.resource("textures/photograph/aged_photograph.png"), Exposure.resource("textures/photograph/aged_photograph_overlay.png"), Exposure.resource("textures/photograph/aged_photograph_album.png"), Exposure.resource("textures/photograph/aged_photograph_album_overlay.png"), ExposurePixelModifiers.AGED);
    private static final List<PhotographRenderProperties> registeredProperties = new ArrayList<PhotographRenderProperties>();
    private final String id;
    private final Predicate<ItemStack> stackPredicate;
    private final ResourceLocation paperTexture;
    private final ResourceLocation overlayTexture;
    private final ResourceLocation albumPaperTexture;
    private final ResourceLocation albumPaperOverlayTexture;
    private final IPixelModifier modifier;

    public PhotographRenderProperties(String id, Predicate<ItemStack> stackPredicate, ResourceLocation paperTexture, ResourceLocation overlayTexture, ResourceLocation albumPaperTexture, ResourceLocation albumPaperOverlayTexture, IPixelModifier modifier) {
        this.id = id;
        this.stackPredicate = stackPredicate;
        this.paperTexture = paperTexture;
        this.overlayTexture = overlayTexture;
        this.albumPaperTexture = albumPaperTexture;
        this.albumPaperOverlayTexture = albumPaperOverlayTexture;
        this.modifier = modifier;
    }

    public boolean matches(ItemStack stack) {
        return this.stackPredicate.test(stack);
    }

    public String getId() {
        return this.id;
    }

    public ResourceLocation getPaperTexture() {
        return this.paperTexture;
    }

    public ResourceLocation getPaperOverlayTexture() {
        return this.overlayTexture;
    }

    public ResourceLocation getAlbumPaperTexture() {
        return this.albumPaperTexture;
    }

    public ResourceLocation getAlbumPaperOverlayTexture() {
        return this.albumPaperOverlayTexture;
    }

    public IPixelModifier getModifier() {
        return this.modifier;
    }

    public boolean hasPaperOverlayTexture() {
        return !this.getPaperOverlayTexture().equals((Object)EMPTY_TEXTURE);
    }

    public boolean hasAlbumPaperOverlayTexture() {
        return !this.getAlbumPaperOverlayTexture().equals((Object)EMPTY_TEXTURE);
    }

    public static void register(PhotographRenderProperties renderProperties) {
        for (int i = registeredProperties.size() - 1; i >= 0; --i) {
            PhotographRenderProperties properties = registeredProperties.get(i);
            if (!properties.getId().equals(renderProperties.getId())) continue;
            registeredProperties.remove(i);
        }
        registeredProperties.add(0, renderProperties);
    }

    public static PhotographRenderProperties get(ItemStack stack) {
        for (PhotographRenderProperties properties : registeredProperties) {
            if (!properties.matches(stack)) continue;
            return properties;
        }
        return DEFAULT;
    }

    static {
        PhotographRenderProperties.register(AGED);
    }
}

