/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.deserialisation;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.worldgen.deserialisation.JsonBiomeDatabaseDeserialiser;
import com.ferreusveritas.dynamictrees.worldgen.deserialisation.JsonMath;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class DensitySelectorDeserialiser
implements JsonBiomeDatabaseDeserialiser<BiomePropertySelectors.DensitySelector> {
    @Override
    public Result<BiomePropertySelectors.DensitySelector, JsonElement> deserialise(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(JsonObject.class, this::readDensitySelector).elseMapIfType(JsonArray.class, this::createScaleDensitySelector).elseMapIfType(Float.class, this::createStaticDensitySelector).elseTypeError();
    }

    private BiomePropertySelectors.DensitySelector createStaticDensitySelector(float density) {
        return (rnd, n) -> density;
    }

    private BiomePropertySelectors.DensitySelector createScaleDensitySelector(JsonArray jsonArray, Consumer<String> warningConsumer) {
        ArrayList parameters = new ArrayList();
        for (JsonElement element : jsonArray) {
            JsonDeserialisers.FLOAT.deserialise(element).ifSuccessOrElse(parameters::add, warningConsumer, warningConsumer);
        }
        switch (parameters.size()) {
            case 0: {
                return (rnd, n) -> n;
            }
            case 1: {
                return (rnd, n) -> n * (double)((Float)parameters.get(0)).floatValue();
            }
            case 2: {
                return (rnd, n) -> n * (double)((Float)parameters.get(0)).floatValue() + (double)((Float)parameters.get(1)).floatValue();
            }
            case 3: {
                return (rnd, n) -> (n * (double)((Float)parameters.get(0)).floatValue() + (double)((Float)parameters.get(1)).floatValue()) * (double)((Float)parameters.get(2)).floatValue();
            }
        }
        return (rnd, n) -> 0.0;
    }

    @Nullable
    private BiomePropertySelectors.DensitySelector readDensitySelector(JsonObject jsonObject, Consumer<String> warningConsumer) throws DeserialisationException {
        return (BiomePropertySelectors.DensitySelector)JsonResult.forInput((JsonElement)jsonObject).mapIfContains("scale", JsonArray.class, this::createScaleDensitySelector).elseMapIfContains("static", Float.class, this::createStaticDensitySelector).elseMapIfContains("math", JsonElement.class, input -> {
            JsonMath jsonMath = new JsonMath((JsonElement)input);
            return (rnd, n) -> jsonMath.apply(rnd, (float)n);
        }).elseTypeError().forEachWarning(warningConsumer).orElseThrow();
    }
}

