/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.deserialisation;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.worldgen.deserialisation.JsonBiomeDatabaseDeserialiser;
import com.ferreusveritas.dynamictrees.worldgen.deserialisation.JsonMath;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class ChanceSelectorDeserialiser
implements JsonBiomeDatabaseDeserialiser<BiomePropertySelectors.ChanceSelector> {
    @Override
    public Result<BiomePropertySelectors.ChanceSelector, JsonElement> deserialise(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(JsonObject.class, this::readChanceSelector).elseMapIfType(Float.class, this::createSimpleChanceSelector).elseMapIfType(String.class, name -> {
            if (name.equalsIgnoreCase("standard")) {
                return (rnd, spc, rad) -> rnd.m_188501_() < (rad > 3 ? 2.0f / (float)rad : 1.0f) ? BiomePropertySelectors.Chance.OK : BiomePropertySelectors.Chance.CANCEL;
            }
            throw new DeserialisationException("Unrecognised named chance selector \"" + name + "\".");
        }).elseTypeError();
    }

    private BiomePropertySelectors.ChanceSelector createSimpleChanceSelector(float value) {
        if (value <= 0.0f) {
            return (rnd, spc, rad) -> BiomePropertySelectors.Chance.CANCEL;
        }
        if (value >= 1.0f) {
            return (rnd, spc, rad) -> BiomePropertySelectors.Chance.OK;
        }
        return (rnd, spc, rad) -> rnd.m_188501_() < value ? BiomePropertySelectors.Chance.OK : BiomePropertySelectors.Chance.CANCEL;
    }

    @Nullable
    private BiomePropertySelectors.ChanceSelector readChanceSelector(JsonObject jsonObject, Consumer<String> warningConsumer) throws DeserialisationException {
        return (BiomePropertySelectors.ChanceSelector)JsonResult.forInput((JsonElement)jsonObject).mapIfContains("static", JsonElement.class, input -> JsonResult.forInput(input).mapIfType(Float.class, this::createSimpleChanceSelector).elseMapIfType(String.class, name -> {
            if (this.isDefault((String)name)) {
                return (rnd, spc, rad) -> BiomePropertySelectors.Chance.UNHANDLED;
            }
            throw new DeserialisationException("Unrecognised named chance selector \"" + name + "\".");
        }).elseTypeError()).elseMapIfContains("math", JsonElement.class, input -> JsonResult.forInput(input).map(element -> {
            JsonMath jsonMath = new JsonMath((JsonElement)input);
            return (rnd, spc, rad) -> rnd.m_188501_() < jsonMath.apply(rnd, spc, rad) ? BiomePropertySelectors.Chance.OK : BiomePropertySelectors.Chance.CANCEL;
        })).map(result -> {
            result.getWarnings().forEach(warningConsumer);
            return (BiomePropertySelectors.ChanceSelector)result.orElseThrow();
        }).orElseThrow();
    }
}

