/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.util.holderset.DTBiomeHolderSet;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public class BiomeDatabase {
    private final Map<DTBiomeHolderSet, JsonEntry> jsonEntries = new LinkedHashMap<DTBiomeHolderSet, JsonEntry>();
    private final Map<ResourceLocation, Entry> entries = new HashMap<ResourceLocation, Entry>();

    public JsonEntry getJsonEntry(DTBiomeHolderSet biomes) {
        return this.jsonEntries.computeIfAbsent(biomes, k -> new JsonEntry(this));
    }

    public Entry getEntry(Holder<Biome> biomeHolder) {
        return this.getEntry((ResourceKey<Biome>)((ResourceKey)biomeHolder.m_203543_().orElseThrow()));
    }

    public Entry getEntry(ResourceKey<Biome> biomeKey) {
        ResourceLocation biomeRegistryName = biomeKey.m_135782_();
        if (this.entries.containsKey(biomeRegistryName)) {
            return this.entries.get(biomeRegistryName);
        }
        Entry entry = new Entry(this, biomeKey);
        this.entries.put(biomeRegistryName, entry);
        this.jsonEntries.forEach((biomes, jsonEntry) -> {
            if (biomes.containsKey(biomeKey)) {
                jsonEntry.copyTo(entry);
            }
        });
        return entry;
    }

    public Entry getEntry(ResourceLocation biomeResLoc) {
        return this.entries.get(biomeResLoc);
    }

    public Collection<Entry> getAllEntries() {
        return this.entries.values();
    }

    public void reset() {
        this.jsonEntries.clear();
        this.entries.clear();
    }

    public boolean isPopulated() {
        return this.entries.size() > 0;
    }

    public BiomePropertySelectors.SpeciesSelector getSpecies(Holder<Biome> biome) {
        return this.getEntry(biome).getSpeciesSelector();
    }

    public BiomePropertySelectors.ChanceSelector getChance(Holder<Biome> biome) {
        return this.getEntry(biome).getChanceSelector();
    }

    public BiomePropertySelectors.DensitySelector getDensitySelector(Holder<Biome> biome) {
        return this.getEntry(biome).getDensitySelector();
    }

    public float getForestness(Holder<Biome> biome) {
        return this.getEntry(biome).getForestness();
    }

    public String getHeightmap(Holder<Biome> biome) {
        return this.getEntry(biome).getHeightmap();
    }

    public Function<Integer, Integer> getMultipass(Holder<Biome> biome) {
        return this.getEntry(biome).getMultipass();
    }

    public BiomeDatabase setForestness(Holder<Biome> biome, float forestness) {
        this.getEntry(biome).setForestness((float)Math.max((double)forestness, (Double)DTConfigs.SEED_MIN_FORESTNESS.get()));
        return this;
    }

    public BiomeDatabase setHeightmap(Holder<Biome> biome, String heightmap) {
        this.getEntry(biome).setHeightmap(heightmap);
        return this;
    }

    public BiomeDatabase setMultipass(Holder<Biome> biome, Function<Integer, Integer> multipass) {
        this.getEntry(biome).setMultipass(multipass);
        return this;
    }

    public static BiomeDatabase copyOf(BiomeDatabase database) {
        BiomeDatabase databaseCopy = new BiomeDatabase();
        databaseCopy.jsonEntries.putAll(database.jsonEntries);
        databaseCopy.entries.putAll(database.entries);
        return databaseCopy;
    }

    public static class JsonEntry
    extends Entry {
        private boolean force = false;
        private boolean changedChanceSelector = false;
        private Operation chanceSelectorOp = Operation.REPLACE;
        private boolean changedDensitySelector = false;
        private Operation densitySelectorOp = Operation.REPLACE;
        private boolean changedSpeciesSelector = false;
        private Operation speciesSelectorOp = Operation.REPLACE;
        private boolean changedBlacklisted = false;
        private boolean changedForestness = false;
        private boolean changedHeightmap = false;
        private boolean changedMultipass = false;

        public JsonEntry(BiomeDatabase database) {
            super(database, null);
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public void copyTo(Entry other) {
            if (this.force) {
                other.reset();
            }
            if (this.changedChanceSelector) {
                other.setChanceSelector(this.chanceSelector, this.chanceSelectorOp);
            }
            if (this.changedDensitySelector) {
                other.setDensitySelector(this.densitySelector, this.densitySelectorOp);
            }
            if (this.changedSpeciesSelector) {
                other.setSpeciesSelector(this.speciesSelector, this.speciesSelectorOp);
            }
            if (this.changedBlacklisted) {
                other.blacklisted = this.blacklisted;
            }
            if (this.changedForestness) {
                other.forestness = this.forestness;
            }
            if (this.changedHeightmap) {
                other.heightmap = this.heightmap;
            }
            if (this.changedMultipass) {
                other.multipass = this.multipass;
            }
            if (this.caveRootedData != null) {
                other.caveRootedData = this.caveRootedData;
            }
        }

        @Override
        public void setChanceSelector(BiomePropertySelectors.ChanceSelector chanceSelector) {
            this.changedChanceSelector = true;
            super.setChanceSelector(chanceSelector);
        }

        @Override
        public void setChanceSelector(BiomePropertySelectors.ChanceSelector selector, Operation op) {
            this.changedChanceSelector = true;
            this.chanceSelectorOp = op;
            super.setChanceSelector(selector);
        }

        @Override
        public void setDensitySelector(BiomePropertySelectors.DensitySelector densitySelector) {
            this.changedDensitySelector = true;
            super.setDensitySelector(densitySelector);
        }

        @Override
        public void setDensitySelector(BiomePropertySelectors.DensitySelector selector, Operation op) {
            this.changedDensitySelector = true;
            this.densitySelectorOp = op;
            super.setDensitySelector(selector);
        }

        @Override
        public void setSpeciesSelector(BiomePropertySelectors.SpeciesSelector speciesSelector) {
            this.changedSpeciesSelector = true;
            super.setSpeciesSelector(speciesSelector);
        }

        @Override
        public void setSpeciesSelector(BiomePropertySelectors.SpeciesSelector selector, Operation op) {
            this.changedSpeciesSelector = true;
            this.speciesSelectorOp = op;
            super.setSpeciesSelector(selector);
        }

        @Override
        public void setBlacklisted(boolean blacklisted) {
            this.changedBlacklisted = true;
            super.setBlacklisted(blacklisted);
        }

        @Override
        public void setForestness(float forestness) {
            this.changedForestness = true;
            super.setForestness(forestness);
        }

        @Override
        public void setHeightmap(String heightmap) {
            this.changedHeightmap = true;
            super.setHeightmap(heightmap);
        }

        @Override
        public void setMultipass(Function<Integer, Integer> multipass) {
            this.changedMultipass = true;
            super.setMultipass(multipass);
        }

        @Override
        public void setCustomMultipass(JsonObject json) {
            this.changedMultipass = true;
            super.setCustomMultipass(json);
        }
    }

    public static class Entry
    extends BaseEntry {
        CaveRootedData caveRootedData;

        public Entry(BiomeDatabase database, @Nullable ResourceKey<Biome> biomeKey) {
            super(database, biomeKey);
        }

        @Nullable
        public CaveRootedData getCaveRootedData() {
            return this.caveRootedData;
        }

        public boolean hasCaveRootedData() {
            return this.caveRootedData != null;
        }

        public CaveRootedData getOrCreateCaveRootedData() {
            if (!this.hasCaveRootedData()) {
                this.caveRootedData = new CaveRootedData();
            }
            return this.caveRootedData;
        }

        public void setCaveRootedData(CaveRootedData data) {
            this.caveRootedData = data;
        }

        @Override
        public void reset() {
            super.reset();
            this.caveRootedData = null;
        }
    }

    public static enum Operation {
        REPLACE,
        SPLICE_BEFORE,
        SPLICE_AFTER;

    }

    public static class CaveRootedData {
        private boolean generateOnSurface = true;
        private int maxDistToSurface = 100;

        public boolean shouldGenerateOnSurface() {
            return this.generateOnSurface;
        }

        public void setGenerateOnSurface(boolean generateOnSurface) {
            this.generateOnSurface = generateOnSurface;
        }

        public int getMaxDistToSurface() {
            return this.maxDistToSurface;
        }

        public void setMaxDistToSurface(int maxDistToSurface) {
            this.maxDistToSurface = maxDistToSurface;
        }
    }

    public static abstract class BaseEntry
    implements EntryReader {
        private final BiomeDatabase database;
        @Nullable
        private final ResourceKey<Biome> biomeKey;
        BiomePropertySelectors.ChanceSelector chanceSelector = (rnd, spc, rad) -> BiomePropertySelectors.Chance.UNHANDLED;
        BiomePropertySelectors.DensitySelector densitySelector = (rnd, nd) -> -1.0;
        BiomePropertySelectors.SpeciesSelector speciesSelector = (pos, dirt, rnd) -> new BiomePropertySelectors.SpeciesSelection();
        BiomePropertySelectors.FeatureCancellation featureCancellation = BiomePropertySelectors.NoFeatureCancellation.INSTANCE;
        Boolean blacklisted = false;
        Float forestness = Float.valueOf(0.0f);
        String heightmap = "WORLD_SURFACE_WG";
        private static final Function<Integer, Integer> defaultMultipass = pass -> pass == 0 ? 0 : -1;
        Function<Integer, Integer> multipass = defaultMultipass;

        public BaseEntry(BiomeDatabase database, @Nullable ResourceKey<Biome> biomeKey) {
            this.database = database;
            this.biomeKey = biomeKey;
        }

        public BiomeDatabase getDatabase() {
            return this.database;
        }

        @Override
        @Nullable
        public ResourceKey<Biome> getBiomeKey() {
            return this.biomeKey;
        }

        @Override
        public BiomePropertySelectors.ChanceSelector getChanceSelector() {
            return this.chanceSelector;
        }

        @Override
        public BiomePropertySelectors.DensitySelector getDensitySelector() {
            return this.densitySelector;
        }

        @Override
        public BiomePropertySelectors.SpeciesSelector getSpeciesSelector() {
            return this.speciesSelector;
        }

        public void setChanceSelector(BiomePropertySelectors.ChanceSelector chanceSelector) {
            this.chanceSelector = chanceSelector;
        }

        public void setChanceSelector(BiomePropertySelectors.ChanceSelector selector, Operation op) {
            BiomePropertySelectors.ChanceSelector existing = this.chanceSelector;
            switch (op) {
                case REPLACE: {
                    this.chanceSelector = selector;
                    break;
                }
                case SPLICE_BEFORE: {
                    this.chanceSelector = (rnd, spc, rad) -> {
                        BiomePropertySelectors.Chance c = selector.getChance(rnd, spc, rad);
                        return c != BiomePropertySelectors.Chance.UNHANDLED ? c : existing.getChance(rnd, spc, rad);
                    };
                    break;
                }
                case SPLICE_AFTER: {
                    this.chanceSelector = (rnd, spc, rad) -> {
                        BiomePropertySelectors.Chance c = existing.getChance(rnd, spc, rad);
                        return c != BiomePropertySelectors.Chance.UNHANDLED ? c : selector.getChance(rnd, spc, rad);
                    };
                }
            }
        }

        public void setDensitySelector(BiomePropertySelectors.DensitySelector densitySelector) {
            this.densitySelector = densitySelector;
        }

        public void setDensitySelector(BiomePropertySelectors.DensitySelector selector, Operation op) {
            BiomePropertySelectors.DensitySelector existing = this.densitySelector;
            switch (op) {
                case REPLACE: {
                    this.densitySelector = selector;
                    break;
                }
                case SPLICE_BEFORE: {
                    this.densitySelector = (rnd, nd) -> {
                        double d = selector.getDensity(rnd, nd);
                        return d >= 0.0 ? d : existing.getDensity(rnd, nd);
                    };
                    break;
                }
                case SPLICE_AFTER: {
                    this.densitySelector = (rnd, nd) -> {
                        double d = existing.getDensity(rnd, nd);
                        return d >= 0.0 ? d : selector.getDensity(rnd, nd);
                    };
                }
            }
        }

        public void setSpeciesSelector(BiomePropertySelectors.SpeciesSelector speciesSelector) {
            this.speciesSelector = speciesSelector;
        }

        public void setSpeciesSelector(BiomePropertySelectors.SpeciesSelector selector, Operation op) {
            BiomePropertySelectors.SpeciesSelector existing = this.speciesSelector;
            switch (op) {
                case REPLACE: {
                    this.speciesSelector = selector;
                    break;
                }
                case SPLICE_BEFORE: {
                    this.speciesSelector = (pos, dirt, rnd) -> {
                        BiomePropertySelectors.SpeciesSelection ss = selector.getSpecies(pos, dirt, rnd);
                        return ss.isHandled() ? ss : existing.getSpecies(pos, dirt, rnd);
                    };
                    break;
                }
                case SPLICE_AFTER: {
                    this.speciesSelector = (pos, dirt, rnd) -> {
                        BiomePropertySelectors.SpeciesSelection ss = existing.getSpecies(pos, dirt, rnd);
                        return ss.isHandled() ? ss : selector.getSpecies(pos, dirt, rnd);
                    };
                }
            }
        }

        @Override
        public BiomePropertySelectors.FeatureCancellation getFeatureCancellation() {
            return this.featureCancellation;
        }

        public BiomePropertySelectors.NormalFeatureCancellation getOrCreateFeatureCancellation() {
            if (this.featureCancellation == BiomePropertySelectors.NoFeatureCancellation.INSTANCE) {
                this.featureCancellation = new BiomePropertySelectors.NormalFeatureCancellation();
            }
            return (BiomePropertySelectors.NormalFeatureCancellation)this.featureCancellation;
        }

        public void setBlacklisted(boolean blacklisted) {
            this.blacklisted = blacklisted;
        }

        @Override
        public boolean isBlacklisted() {
            return this.blacklisted;
        }

        public void setForestness(float forestness) {
            this.forestness = Float.valueOf(forestness);
        }

        public void setHeightmap(String heightmap) {
            this.heightmap = heightmap;
        }

        @Override
        public float getForestness() {
            return this.forestness.floatValue();
        }

        @Override
        public String getHeightmap() {
            return this.heightmap;
        }

        public void setMultipass(Function<Integer, Integer> multipass) {
            this.multipass = multipass;
        }

        @Override
        public Function<Integer, Integer> getMultipass() {
            return this.multipass;
        }

        public void enableDefaultMultipass() {
            this.multipass = pass -> {
                switch (pass) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 3;
                    }
                }
                return -1;
            };
        }

        public void setCustomMultipass(JsonObject json) {
            Map<Integer, Integer> passMap = this.deserialiseCustomMultipass(json);
            this.multipass = pass -> passMap.getOrDefault(pass, -1);
        }

        private Map<Integer, Integer> deserialiseCustomMultipass(JsonObject json) {
            HashMap passMap = Maps.newHashMap();
            for (Map.Entry passEntry : json.entrySet()) {
                try {
                    int pass = Integer.parseInt((String)passEntry.getKey());
                    int radius = JsonDeserialisers.INTEGER.deserialise((JsonElement)passEntry.getValue()).orElse(-1);
                    if (radius == -1) break;
                    passMap.put(pass, radius);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return passMap;
        }

        public void reset() {
            this.speciesSelector = (pos, dirt, rnd) -> new BiomePropertySelectors.SpeciesSelection();
            this.densitySelector = (rnd, nd) -> -1.0;
            this.chanceSelector = (rnd, spc, rad) -> BiomePropertySelectors.Chance.UNHANDLED;
            this.forestness = Float.valueOf(0.0f);
            this.heightmap = "WORLD_SURFACE_WG";
            this.blacklisted = false;
            this.multipass = defaultMultipass;
        }
    }

    public static interface EntryReader {
        public static DataResult<EntryReader> read(ResourceLocation biomeName) {
            Entry entry = BiomeDatabases.getDefault().getEntry(biomeName);
            return DataResult.success((Object)entry);
        }

        @Nullable
        public ResourceKey<Biome> getBiomeKey();

        public BiomePropertySelectors.ChanceSelector getChanceSelector();

        public BiomePropertySelectors.DensitySelector getDensitySelector();

        public BiomePropertySelectors.SpeciesSelector getSpeciesSelector();

        public BiomePropertySelectors.FeatureCancellation getFeatureCancellation();

        public boolean isBlacklisted();

        public float getForestness();

        public String getHeightmap();

        public Function<Integer, Integer> getMultipass();
    }
}

