/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootTable;

public final class LootTableSupplier {
    private final String path;
    private final ResourceLocation name;
    private final ResourceLocation baseName;

    public LootTableSupplier(String basePath, ResourceLocation name) {
        this.path = basePath;
        this.name = name;
        this.baseName = ResourceLocationUtils.prefix(name, this.path);
    }

    public LootTable get(LootDataManager lootTables, Species species) {
        LootTable speciesOverrideTable = lootTables.m_278676_(this.getName(species));
        if (speciesOverrideTable != LootTable.f_79105_) {
            return speciesOverrideTable;
        }
        return lootTables.m_278676_(this.baseName);
    }

    public ResourceLocation getName(Species species) {
        ResourceLocation speciesName = species.getRegistryName();
        return ResourceLocationUtils.surround(this.name, this.path, "/" + speciesName.m_135827_() + "/" + speciesName.m_135815_());
    }

    public ResourceLocation getName() {
        return this.baseName;
    }
}

