/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;

public final class ItemUtils {
    public static void spawnItemStack(Level world, BlockPos pos, ItemStack stack) {
        ItemUtils.spawnItemStack(world, pos, stack, false);
    }

    public static void spawnItemStack(Level world, BlockPos pos, ItemStack stack, boolean searchForAir) {
        if (searchForAir) {
            while (!world.m_46859_(pos)) {
                pos = pos.m_7494_();
            }
        }
        ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
        itemEntity.m_20334_(0.0, 0.0, 0.0);
        world.m_7967_((Entity)itemEntity);
    }

    public static void damageAxe(LivingEntity entity, @Nullable ItemStack heldItem, int radius, NetVolumeNode.Volume woodVolume, boolean forBlockBreak) {
        int damage;
        if (heldItem == null || !heldItem.canPerformAction(ToolActions.AXE_DIG)) {
            return;
        }
        switch ((DynamicTrees.AxeDamage)((Object)DTConfigs.AXE_DAMAGE_MODE.get())) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VANILLA: {
                int n = 1;
                break;
            }
            case THICKNESS: {
                int n = Math.max(1, radius) / 2;
                break;
            }
            case VOLUME: {
                int n = damage = (int)woodVolume.getVolume();
            }
        }
        if (forBlockBreak) {
            --damage;
        }
        if (damage > 0) {
            heldItem.m_41622_(damage, entity, LivingEntity::m_8119_);
        }
    }
}

