/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tree.species;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.DTItemTags;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatures;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.family.NetherFungusFamily;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.mojang.datafixers.util.Function3;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.LogManager;

public class NetherFungusSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = NetherFungusSpecies.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)NetherFungusSpecies::new));

    public NetherFungusSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
        if (!(family instanceof NetherFungusFamily)) {
            LogManager.getLogger().warn("Family " + family.getRegistryName() + " for nether fungus species " + this.getRegistryName() + " is not of type " + NetherFungusFamily.class);
        }
        this.setSaplingShape(CommonVoxelShapes.SAPLING);
    }

    @Override
    public Species setDefaultGrowingParameters() {
        this.setBasicGrowingParameters(0.0f, 14.0f, 0, 4, 1.0f);
        return super.setDefaultGrowingParameters();
    }

    @Override
    protected void setStandardSoils() {
        this.addAcceptableSoils("nether_soil_like", "fungus_like", "dirt_like");
    }

    @Override
    public Species setPreReloadDefaults() {
        return this.setDefaultGrowingParameters().setSaplingSound(SoundType.f_56711_).setCanSaplingGrowNaturally(false).envFactor((TagKey<Biome>)Tags.Biomes.IS_COLD, 0.25f).envFactor((TagKey<Biome>)Tags.Biomes.IS_WET, 0.75f);
    }

    @Override
    public Species setPostReloadDefaults() {
        if (!this.hasGenFeatures()) {
            this.addGenFeature(GenFeatures.CLEAR_VOLUME).addGenFeature(GenFeatures.SHROOMLIGHT);
        }
        return super.setPostReloadDefaults();
    }

    @Override
    public boolean isAcceptableSoilForWorldgen(LevelAccessor level, BlockPos pos, BlockState soilBlockState) {
        if (soilBlockState.m_60734_() == Blocks.f_50134_) {
            return true;
        }
        return super.isAcceptableSoilForWorldgen(level, pos, soilBlockState);
    }

    @Override
    public float defaultSeedComposterChance() {
        return 0.65f;
    }

    @Override
    public List<TagKey<Block>> defaultSaplingTags() {
        return Collections.singletonList(DTBlockTags.FUNGUS_CAPS);
    }

    @Override
    public List<TagKey<Item>> defaultSeedTags() {
        return Collections.singletonList(DTItemTags.FUNGUS_CAPS);
    }

    @Override
    public void addSaplingTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation, ResourceLocation barkTextureLocation) {
        ResourceLocation capLoc = this.getTexturePath("sapling").orElse(ResourceLocationUtils.surround(this.getRegistryName(), "block/", "_cap"));
        textureConsumer.accept("stem", capLoc);
        textureConsumer.accept("cap", capLoc);
    }

    @Override
    public SoundEvent getFallingTreeStartSound(float treeVolume, boolean hasLeaves) {
        return (SoundEvent)DTRegistries.FALLING_TREE_FUNGUS_START.get();
    }

    @Override
    public SoundEvent getFallingTreeEndSound(float treeVolume, boolean hasLeaves) {
        return (SoundEvent)DTRegistries.FALLING_TREE_FUNGUS_END.get();
    }

    @Override
    public SoundEvent getFallingBranchEndSound(float treeVolume, boolean hasLeaves, boolean fellOnWater) {
        return hasLeaves ? (SoundEvent)DTRegistries.FALLING_TREE_FUNGUS_SMALL_END.get() : (SoundEvent)DTRegistries.FALLING_TREE_SMALL_END_BARE.get();
    }

    @Override
    public float getFallingTreePitch(float treeVolume) {
        return 1.5f / (1.0f + treeVolume * 0.04f);
    }
}

