/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.poissondisc;

import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import java.util.Arrays;
import java.util.List;

public class PoissonDiscChunkSet {
    private byte[] discData;
    public boolean generated = false;

    public PoissonDiscChunkSet() {
        this.discData = new byte[16];
    }

    public PoissonDiscChunkSet(byte[] data) {
        this.generated = true;
        this.discData = data != null && data.length == 16 ? Arrays.copyOf(data, 16) : new byte[16];
    }

    public List<PoissonDisc> getDiscs(List<PoissonDisc> discs, int chunkX, int chunkZ) {
        for (int tile = 0; tile < 16; ++tile) {
            byte cd = this.discData[tile];
            if (cd == 0) continue;
            if ((cd & 0x80) != 0) {
                int flip = (cd | cd << 1) & 3;
                discs.add(PoissonDiscChunkSet.unpackDiscData(tile, 0x10 ^ flip, chunkX, chunkZ));
                discs.add(PoissonDiscChunkSet.unpackDiscData(tile, 0x1F ^ flip, chunkX, chunkZ));
                continue;
            }
            if ((cd & 0x70) == 0) continue;
            discs.add(PoissonDiscChunkSet.unpackDiscData(tile, cd, chunkX, chunkZ));
        }
        return discs;
    }

    public void clearDiscs() {
        Arrays.fill(this.discData, (byte)0);
    }

    public List<PoissonDisc> addDiscs(List<PoissonDisc> discs) {
        this.clearDiscs();
        for (PoissonDisc d : discs) {
            this.addDisc(d);
        }
        return discs;
    }

    private static PoissonDisc unpackDiscData(int tile, int diskData, int chunkX, int chunkZ) {
        int radius = PoissonDiscChunkSet.getRadiusFromDiscData(diskData);
        int x = tile << 2 & 0xC;
        int z = tile & 0xC;
        return new PoissonDisc(chunkX << 4 | x | diskData >> 2 & 3, chunkZ << 4 | z | diskData & 3, radius, true);
    }

    private static int getRadiusFromDiscData(int discData) {
        return (discData >> 4 & 7) + 1;
    }

    private static byte buildDiscData(PoissonDisc c) {
        return (byte)((c.radius - 1 & 7) << 4 | (c.x & 3) << 2 | c.z & 3);
    }

    private static int calcTileNum(PoissonDisc c) {
        return c.z & 0xC | (c.x & 0xC) >> 2;
    }

    public boolean addDisc(PoissonDisc d) {
        if (d.radius >= 2 && d.radius <= 8) {
            int tile = PoissonDiscChunkSet.calcTileNum(d);
            byte cd = this.discData[tile];
            if (cd != 0) {
                if (d.radius == 2 && PoissonDiscChunkSet.getRadiusFromDiscData(cd) == 2) {
                    int oldDiscPos = cd & 0xF;
                    int newDiscPos = (d.x & 3) << 2 | d.z & 3;
                    switch (oldDiscPos << 4 | newDiscPos) {
                        case 15: 
                        case 240: {
                            this.discData[tile] = -128;
                            return true;
                        }
                        case 60: 
                        case 195: {
                            this.discData[tile] = -127;
                            return true;
                        }
                    }
                }
            } else {
                this.discData[tile] = PoissonDiscChunkSet.buildDiscData(d);
                return true;
            }
        }
        return false;
    }

    public byte[] getDiscData() {
        return this.discData;
    }

    public void setDiscData(byte[] discData) {
        this.discData = Arrays.copyOf(discData, 16);
    }
}

