/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemapper;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class PodGenerationNode
implements NodeInspector {
    private final Pod pod;
    private final PodPlacer podPlacer;
    @Nullable
    private final Float seasonValue;
    private final int blocksPerPlacedPod;
    private final BlockPos rootPos;
    private final int lowestTrunkHeight;
    private boolean finished = false;

    public PodGenerationNode(Pod pod, PodPlacer podPlacer, @Nullable Float seasonValue, int blocksPerPlacedPods, BlockPos rootPos, int lowestTrunkHeight) {
        this.podPlacer = podPlacer;
        this.seasonValue = seasonValue;
        this.blocksPerPlacedPod = blocksPerPlacedPods;
        this.pod = pod;
        this.rootPos = rootPos;
        this.lowestTrunkHeight = lowestTrunkHeight;
    }

    @Override
    public boolean run(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        if (!this.finished) {
            int radius;
            if (pos.m_123342_() - this.rootPos.m_7494_().m_123342_() < this.lowestTrunkHeight) {
                return false;
            }
            BranchBlock branch = TreeHelper.getBranch(state);
            if (branch != null && this.pod.isValidRadius(radius = branch.getRadius(state))) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos deltaPos;
                    int hashCode = CoordUtils.coordHashCode(pos.m_121955_(dir.m_122436_()), 1);
                    if (hashCode % 97 % this.blocksPerPlacedPod != 0 || !level.m_46859_(deltaPos = pos.m_121945_(dir)) && !(level.m_8055_(deltaPos).m_60734_() instanceof TrunkShellBlock)) continue;
                    if (!dir.m_122434_().m_122479_()) {
                        dir = Direction.NORTH;
                    }
                    this.podPlacer.place(level, deltaPos, this.seasonValue, dir.m_122424_(), radius);
                    this.finished = true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean returnRun(BlockState state, LevelAccessor level, BlockPos pos, Direction fromDir) {
        return false;
    }

    public static interface PodPlacer {
        public void place(LevelAccessor var1, BlockPos var2, @Nullable Float var3, Direction var4, int var5);
    }
}

