/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature.context;

import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.GenerationContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class PostGenerationContext
extends GenerationContext {
    private final BlockPos originPos;
    private final Holder<Biome> biome;
    private final int radius;
    private final List<BlockPos> endPoints;
    private final SafeChunkBounds bounds;
    private final BlockState initialDirtState;
    private final Float seasonValue;
    private final Float fruitProductionFactor;

    public PostGenerationContext(com.ferreusveritas.dynamictrees.worldgen.GenerationContext context, List<BlockPos> endPoints, BlockState initialDirtState) {
        super(context.level(), context.rootPos().m_7949_(), context.species());
        this.originPos = context.originPos();
        this.biome = context.biome();
        this.radius = context.radius();
        this.endPoints = endPoints;
        this.bounds = context.safeBounds();
        this.initialDirtState = initialDirtState;
        this.seasonValue = SeasonHelper.getSeasonValue(context.levelContext(), this.pos());
        this.fruitProductionFactor = Float.valueOf(this.species().seasonalFruitProductionFactor(context.levelContext(), this.pos()));
    }

    public BlockPos originPos() {
        return this.originPos;
    }

    public Holder<Biome> biome() {
        return this.biome;
    }

    public int radius() {
        return this.radius;
    }

    public List<BlockPos> endPoints() {
        return this.endPoints;
    }

    public SafeChunkBounds bounds() {
        return this.bounds;
    }

    public BlockState initialDirtState() {
        return this.initialDirtState;
    }

    public Float seasonValue() {
        return this.seasonValue;
    }

    public Float fruitProductionFactor() {
        return this.fruitProductionFactor;
    }

    public final boolean isWorldGen() {
        return this.bounds != SafeChunkBounds.ANY;
    }
}

