/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeature;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class UndergrowthGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Species> SPECIES_A = ConfigurationProperty.property("undergrowth_species", Species.class);
    public static final ConfigurationProperty<Species> SPECIES_B = ConfigurationProperty.property("secondary_undergrowth_species", Species.class);
    public static final ConfigurationProperty<Float> PROPORTION = ConfigurationProperty.floatProperty("proportion_of_secondary_species");
    int checkDown = -1;
    int checkUp = 4;

    public UndergrowthGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(SPECIES_A, SPECIES_B, PROPORTION);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(SPECIES_A, Species.NULL_SPECIES)).with(SPECIES_B, Species.NULL_SPECIES)).with(PROPORTION, Float.valueOf(0.4f));
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        return this.tryToPlaceTree(configuration, context.levelContext(), context.level(), context.pos(), context.radius());
    }

    private boolean tryToPlaceTree(GenFeatureConfiguration config, LevelContext levelContext, LevelAccessor level, BlockPos rootPos, int radius) {
        if (radius <= 2) {
            return false;
        }
        Vec3 vTree = new Vec3((double)rootPos.m_123341_(), (double)rootPos.m_123342_(), (double)rootPos.m_123343_()).m_82520_(0.5, 0.5, 0.5);
        int placedBushes = 0;
        for (int attempts = 0; placedBushes <= 2 && attempts <= 10; ++attempts) {
            Species species;
            int rad = Mth.m_14045_((int)(level.m_213780_().m_188503_(radius - 2) + 2), (int)2, (int)(radius - 1));
            Vec3 v = vTree.m_82549_(new Vec3(1.0, 0.0, 0.0).m_82490_((double)rad).m_82524_((float)((double)level.m_213780_().m_188501_() * Math.PI * 2.0)));
            BlockPos vPos = BlockPos.m_274446_((Position)v);
            BlockPos groundPos = CoordUtils.findWorldSurface(level, vPos, true);
            if (this.areTreesAround(level, groundPos)) continue;
            Species species2 = species = level.m_213780_().m_188501_() < config.get(PROPORTION).floatValue() ? config.get(SPECIES_B) : config.get(SPECIES_A);
            if (!this.placeTreeAtLocation(levelContext, groundPos, species)) continue;
            ++placedBushes;
        }
        return placedBushes > 0;
    }

    private boolean areTreesAround(LevelAccessor world, BlockPos rootPos) {
        for (int i = this.checkDown; i <= this.checkUp; ++i) {
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos offsetPos = rootPos.m_121955_(dir.getOffset()).m_6630_(i);
                if (!TreeHelper.isBranch(world.m_8055_(offsetPos))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean placeTreeAtLocation(LevelContext levelContext, BlockPos newRootPos, Species species) {
        LevelAccessor level = levelContext.accessor();
        for (int i = 1; i >= -1; --i) {
            BlockPos offsetRootPos = newRootPos.m_6630_(i);
            if (!species.isAcceptableSoil(level.m_8055_(offsetRootPos))) continue;
            if (level instanceof WorldGenRegion) {
                species.generate(new GenerationContext(levelContext, species, offsetRootPos, offsetRootPos.m_122032_(), (Holder<Biome>)level.m_203495_(offsetRootPos.m_123341_(), offsetRootPos.m_123342_(), offsetRootPos.m_123343_()), Direction.Plane.HORIZONTAL.m_235690_(level.m_213780_()), 2, SafeChunkBounds.ANY_WG));
            }
            return true;
        }
        return false;
    }
}

